/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.util;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.util.Models;

public class ParcelableHelper {
    public void addWriteToParcel(JDefinedClass jclass) {
        JMethod method = jclass.method(1, Void.TYPE, "writeToParcel");
        JVar dest = method.param((JType)jclass.owner().directClass("android.os.Parcel"), "dest");
        method.param(Integer.TYPE, "flags");
        if (this.extendsParcelable(jclass)) {
            method.body().directStatement("super.writeToParcel(dest, flags);");
        }
        for (JFieldVar f : jclass.fields().values()) {
            if ((f.mods().getValue() & 0x10) == 16) continue;
            if (f.type().erasure().name().equals("List")) {
                method.body().invoke((JExpression)dest, "writeList").arg((JExpression)f);
                continue;
            }
            method.body().invoke((JExpression)dest, "writeValue").arg((JExpression)f);
        }
    }

    public void addDescribeContents(JDefinedClass jclass) {
        JMethod method = jclass.method(1, Integer.TYPE, "describeContents");
        method.body()._return(JExpr.lit((int)0));
    }

    public void addCreator(JDefinedClass jclass) {
        JClass creatorType = jclass.owner().directClass("android.os.Parcelable.Creator").narrow((JClass)jclass);
        JDefinedClass creatorClass = jclass.owner().anonymousClass(creatorType);
        this.addCreateFromParcel(jclass, creatorClass);
        this.addNewArray(jclass, creatorClass);
        JFieldVar creatorField = jclass.field(25, (JType)creatorType, "CREATOR");
        creatorField.init((JExpression)JExpr._new((JClass)creatorClass));
    }

    public void addConstructorFromParcel(JDefinedClass jclass) {
        JMethod ctorFromParcel = jclass.constructor(2);
        JVar in = ctorFromParcel.param((JType)jclass.owner().directClass("android.os.Parcel"), "in");
        if (this.extendsParcelable(jclass)) {
            ctorFromParcel.body().directStatement("super(in);");
        }
        for (JFieldVar f : jclass.fields().values()) {
            if ((f.mods().getValue() & 0x10) == 16) continue;
            if (f.type().erasure().name().equals("List")) {
                ctorFromParcel.body().invoke((JExpression)in, "readList").arg((JExpression)JExpr._this().ref((JVar)f)).arg(JExpr.direct((String)(this.getListType(f.type()) + ".class.getClassLoader()")));
                continue;
            }
            ctorFromParcel.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)f), (JExpression)JExpr.cast((JType)f.type(), (JExpression)in.invoke("readValue").arg(JExpr.direct((String)(f.type().erasure().name() + ".class.getClassLoader()")))));
        }
    }

    private void addNewArray(JDefinedClass jclass, JDefinedClass creatorClass) {
        JMethod newArray = creatorClass.method(1, (JType)jclass.array(), "newArray");
        newArray.param(Integer.TYPE, "size");
        newArray.body()._return(JExpr.direct((String)("new " + jclass.name() + "[size]")));
    }

    private void addCreateFromParcel(JDefinedClass jclass, JDefinedClass creatorClass) {
        JMethod createFromParcel = creatorClass.method(1, (JType)jclass, "createFromParcel");
        JVar in = createFromParcel.param((JType)jclass.owner().directClass("android.os.Parcel"), "in");
        Models.suppressWarnings(createFromParcel, "unchecked");
        createFromParcel.body()._return((JExpression)JExpr._new((JClass)jclass).arg((JExpression)in));
    }

    private boolean extendsParcelable(JDefinedClass jclass) {
        Iterator interfaces;
        Iterator iterator = interfaces = jclass._extends() != null ? jclass._extends()._implements() : null;
        if (interfaces != null) {
            while (interfaces.hasNext()) {
                JClass iface = (JClass)interfaces.next();
                if (!iface.erasure().name().equals("Parcelable")) continue;
                return true;
            }
        }
        return false;
    }

    private String getListType(JType jType) {
        String typeName = jType.fullName();
        return StringUtils.substringBeforeLast((String)StringUtils.substringAfter((String)typeName, (String)"<"), (String)">");
    }
}

