/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.ChaosZKClient;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.HBaseClusterManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ZNodeClusterManager
extends Configured
implements ClusterManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)ZNodeClusterManager.class.getName());
    private static final String SIGKILL = "SIGKILL";
    private static final String SIGSTOP = "SIGSTOP";
    private static final String SIGCONT = "SIGCONT";

    private String getZKQuorumServersStringFromHbaseConfig() {
        String port = Integer.toString(this.getConf().getInt("hbase.zookeeper.property.clientPort", 2181));
        String[] serverHosts = this.getConf().getStrings("hbase.zookeeper.quorum", new String[]{"localhost"});
        for (int i = 0; i < serverHosts.length; ++i) {
            serverHosts[i] = serverHosts[i] + ":" + port;
        }
        return Arrays.asList(serverHosts).stream().collect(Collectors.joining(","));
    }

    private String createZNode(String hostname, String cmd) throws IOException {
        LOG.info("Zookeeper Mode enabled sending command to zookeeper + " + cmd + "hostname:" + hostname);
        ChaosZKClient chaosZKClient = new ChaosZKClient(this.getZKQuorumServersStringFromHbaseConfig());
        return chaosZKClient.submitTask(new ChaosZKClient.TaskObject(cmd, hostname));
    }

    protected HBaseClusterManager.CommandProvider getCommandProvider(ClusterManager.ServiceType service) throws IOException {
        switch (service) {
            case HADOOP_DATANODE: 
            case HADOOP_NAMENODE: {
                return new HBaseClusterManager.HadoopShellCommandProvider(this.getConf());
            }
            case ZOOKEEPER_SERVER: {
                return new HBaseClusterManager.ZookeeperShellCommandProvider(this.getConf());
            }
        }
        return new HBaseClusterManager.HBaseShellCommandProvider(this.getConf());
    }

    public void signal(ClusterManager.ServiceType service, String signal, String hostname) throws IOException {
        this.createZNode(hostname, CmdType.exec.toString() + this.getCommandProvider(service).signalCommand(service, signal));
    }

    private void createOpCommand(String hostname, ClusterManager.ServiceType service, HBaseClusterManager.CommandProvider.Operation op) throws IOException {
        this.createZNode(hostname, CmdType.exec.toString() + this.getCommandProvider(service).getCommand(service, op));
    }

    @Override
    public void start(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.createOpCommand(hostname, service, HBaseClusterManager.CommandProvider.Operation.START);
    }

    @Override
    public void stop(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.createOpCommand(hostname, service, HBaseClusterManager.CommandProvider.Operation.STOP);
    }

    @Override
    public void restart(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.createOpCommand(hostname, service, HBaseClusterManager.CommandProvider.Operation.RESTART);
    }

    @Override
    public void kill(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.signal(service, SIGKILL, hostname);
    }

    @Override
    public void suspend(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.signal(service, SIGSTOP, hostname);
    }

    @Override
    public void resume(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        this.signal(service, SIGCONT, hostname);
    }

    @Override
    public boolean isRunning(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        return Boolean.parseBoolean(this.createZNode(hostname, CmdType.bool.toString() + this.getCommandProvider(service).isRunningCommand(service)));
    }

    @Override
    public boolean isSuspended(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        String ret = this.createZNode(hostname, this.getCommandProvider(service).getStateCommand(service));
        return ret != null && ret.trim().equals("T");
    }

    @Override
    public boolean isResumed(ClusterManager.ServiceType service, String hostname, int port) throws IOException {
        String ret = this.createZNode(hostname, this.getCommandProvider(service).getStateCommand(service));
        return ret != null && !ret.trim().equals("T");
    }

    static enum CmdType {
        exec,
        bool;

    }
}

