/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2.generated;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.thrift2.generated.TColumnFamilyDescriptor;
import org.apache.hadoop.hbase.thrift2.generated.TDurability;
import org.apache.hadoop.hbase.thrift2.generated.TTableName;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TTableDescriptor
implements TBase<TTableDescriptor, _Fields>,
Serializable,
Cloneable,
Comparable<TTableDescriptor> {
    private static final TStruct STRUCT_DESC = new TStruct("TTableDescriptor");
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 12, 1);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 2);
    private static final TField ATTRIBUTES_FIELD_DESC = new TField("attributes", 13, 3);
    private static final TField DURABILITY_FIELD_DESC = new TField("durability", 8, 4);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TTableDescriptorStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TTableDescriptorTupleSchemeFactory();
    @Nullable
    public TTableName tableName;
    @Nullable
    public List<TColumnFamilyDescriptor> columns;
    @Nullable
    public Map<ByteBuffer, ByteBuffer> attributes;
    @Nullable
    public TDurability durability;
    private static final _Fields[] optionals = new _Fields[]{_Fields.COLUMNS, _Fields.ATTRIBUTES, _Fields.DURABILITY};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TTableDescriptor() {
    }

    public TTableDescriptor(TTableName tableName) {
        this();
        this.tableName = tableName;
    }

    public TTableDescriptor(TTableDescriptor other) {
        if (other.isSetTableName()) {
            this.tableName = new TTableName(other.tableName);
        }
        if (other.isSetColumns()) {
            ArrayList<TColumnFamilyDescriptor> __this__columns = new ArrayList<TColumnFamilyDescriptor>(other.columns.size());
            for (TColumnFamilyDescriptor other_element : other.columns) {
                __this__columns.add(new TColumnFamilyDescriptor(other_element));
            }
            this.columns = __this__columns;
        }
        if (other.isSetAttributes()) {
            HashMap<ByteBuffer, ByteBuffer> __this__attributes = new HashMap<ByteBuffer, ByteBuffer>(other.attributes);
            this.attributes = __this__attributes;
        }
        if (other.isSetDurability()) {
            this.durability = other.durability;
        }
    }

    public TTableDescriptor deepCopy() {
        return new TTableDescriptor(this);
    }

    public void clear() {
        this.tableName = null;
        this.columns = null;
        this.attributes = null;
        this.durability = null;
    }

    @Nullable
    public TTableName getTableName() {
        return this.tableName;
    }

    public TTableDescriptor setTableName(@Nullable TTableName tableName) {
        this.tableName = tableName;
        return this;
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
        if (!value) {
            this.tableName = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    @Nullable
    public Iterator<TColumnFamilyDescriptor> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(TColumnFamilyDescriptor elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<TColumnFamilyDescriptor>();
        }
        this.columns.add(elem);
    }

    @Nullable
    public List<TColumnFamilyDescriptor> getColumns() {
        return this.columns;
    }

    public TTableDescriptor setColumns(@Nullable List<TColumnFamilyDescriptor> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public int getAttributesSize() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public void putToAttributes(ByteBuffer key, ByteBuffer val) {
        if (this.attributes == null) {
            this.attributes = new HashMap<ByteBuffer, ByteBuffer>();
        }
        this.attributes.put(key, val);
    }

    @Nullable
    public Map<ByteBuffer, ByteBuffer> getAttributes() {
        return this.attributes;
    }

    public TTableDescriptor setAttributes(@Nullable Map<ByteBuffer, ByteBuffer> attributes) {
        this.attributes = attributes;
        return this;
    }

    public void unsetAttributes() {
        this.attributes = null;
    }

    public boolean isSetAttributes() {
        return this.attributes != null;
    }

    public void setAttributesIsSet(boolean value) {
        if (!value) {
            this.attributes = null;
        }
    }

    @Nullable
    public TDurability getDurability() {
        return this.durability;
    }

    public TTableDescriptor setDurability(@Nullable TDurability durability) {
        this.durability = durability;
        return this;
    }

    public void unsetDurability() {
        this.durability = null;
    }

    public boolean isSetDurability() {
        return this.durability != null;
    }

    public void setDurabilityIsSet(boolean value) {
        if (!value) {
            this.durability = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TABLE_NAME: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                this.setTableName((TTableName)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
                break;
            }
            case ATTRIBUTES: {
                if (value == null) {
                    this.unsetAttributes();
                    break;
                }
                this.setAttributes((Map)value);
                break;
            }
            case DURABILITY: {
                if (value == null) {
                    this.unsetDurability();
                    break;
                }
                this.setDurability((TDurability)((Object)value));
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLE_NAME: {
                return this.getTableName();
            }
            case COLUMNS: {
                return this.getColumns();
            }
            case ATTRIBUTES: {
                return this.getAttributes();
            }
            case DURABILITY: {
                return this.getDurability();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLE_NAME: {
                return this.isSetTableName();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
            case ATTRIBUTES: {
                return this.isSetAttributes();
            }
            case DURABILITY: {
                return this.isSetDurability();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TTableDescriptor) {
            return this.equals((TTableDescriptor)that);
        }
        return false;
    }

    public boolean equals(TTableDescriptor that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!this.columns.equals(that.columns)) {
                return false;
            }
        }
        boolean this_present_attributes = this.isSetAttributes();
        boolean that_present_attributes = that.isSetAttributes();
        if (this_present_attributes || that_present_attributes) {
            if (!this_present_attributes || !that_present_attributes) {
                return false;
            }
            if (!this.attributes.equals(that.attributes)) {
                return false;
            }
        }
        boolean this_present_durability = this.isSetDurability();
        boolean that_present_durability = that.isSetDurability();
        if (this_present_durability || that_present_durability) {
            if (!this_present_durability || !that_present_durability) {
                return false;
            }
            if (!this.durability.equals((Object)that.durability)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetTableName() ? 131071 : 524287);
        if (this.isSetTableName()) {
            hashCode = hashCode * 8191 + this.tableName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetColumns() ? 131071 : 524287);
        if (this.isSetColumns()) {
            hashCode = hashCode * 8191 + this.columns.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetAttributes() ? 131071 : 524287);
        if (this.isSetAttributes()) {
            hashCode = hashCode * 8191 + this.attributes.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDurability() ? 131071 : 524287);
        if (this.isSetDurability()) {
            hashCode = hashCode * 8191 + this.durability.getValue();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TTableDescriptor other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetTableName(), other.isSetTableName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((Comparable)this.tableName, (Comparable)other.tableName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetColumns(), other.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, other.columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAttributes(), other.isSetAttributes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAttributes() && (lastComparison = TBaseHelper.compareTo(this.attributes, other.attributes)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDurability(), other.isSetDurability());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDurability() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.durability), (Comparable)((Object)other.durability))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TTableDescriptor.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TTableDescriptor.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TTableDescriptor(");
        boolean first = true;
        sb.append("tableName:");
        if (this.tableName == null) {
            sb.append("null");
        } else {
            sb.append(this.tableName);
        }
        first = false;
        if (this.isSetColumns()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("columns:");
            if (this.columns == null) {
                sb.append("null");
            } else {
                sb.append(this.columns);
            }
            first = false;
        }
        if (this.isSetAttributes()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("attributes:");
            if (this.attributes == null) {
                sb.append("null");
            } else {
                sb.append(this.attributes);
            }
            first = false;
        }
        if (this.isSetDurability()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("durability:");
            if (this.durability == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.durability);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.tableName == null) {
            throw new TProtocolException("Required field 'tableName' was not present! Struct: " + this.toString());
        }
        if (this.tableName != null) {
            this.tableName.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 1, (FieldValueMetaData)new StructMetaData(12, TTableName.class)));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TColumnFamilyDescriptor.class))));
        tmpMap.put(_Fields.ATTRIBUTES, new FieldMetaData("attributes", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11, true), new FieldValueMetaData(11, true))));
        tmpMap.put(_Fields.DURABILITY, new FieldMetaData("durability", 2, (FieldValueMetaData)new EnumMetaData(16, TDurability.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TTableDescriptor.class, metaDataMap);
    }

    private static class TTableDescriptorTupleScheme
    extends TupleScheme<TTableDescriptor> {
        private TTableDescriptorTupleScheme() {
        }

        public void write(TProtocol prot, TTableDescriptor struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            struct.tableName.write((TProtocol)oprot);
            BitSet optionals = new BitSet();
            if (struct.isSetColumns()) {
                optionals.set(0);
            }
            if (struct.isSetAttributes()) {
                optionals.set(1);
            }
            if (struct.isSetDurability()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetColumns()) {
                oprot.writeI32(struct.columns.size());
                for (TColumnFamilyDescriptor tColumnFamilyDescriptor : struct.columns) {
                    tColumnFamilyDescriptor.write((TProtocol)oprot);
                }
            }
            if (struct.isSetAttributes()) {
                oprot.writeI32(struct.attributes.size());
                for (Map.Entry entry : struct.attributes.entrySet()) {
                    oprot.writeBinary((ByteBuffer)entry.getKey());
                    oprot.writeBinary((ByteBuffer)entry.getValue());
                }
            }
            if (struct.isSetDurability()) {
                oprot.writeI32(struct.durability.getValue());
            }
        }

        public void read(TProtocol prot, TTableDescriptor struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.tableName = new TTableName();
            struct.tableName.read((TProtocol)iprot);
            struct.setTableNameIsSet(true);
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                TList _list173 = iprot.readListBegin((byte)12);
                struct.columns = new ArrayList<TColumnFamilyDescriptor>(_list173.size);
                for (int _i175 = 0; _i175 < _list173.size; ++_i175) {
                    TColumnFamilyDescriptor _elem174 = new TColumnFamilyDescriptor();
                    _elem174.read((TProtocol)iprot);
                    struct.columns.add(_elem174);
                }
                struct.setColumnsIsSet(true);
            }
            if (incoming.get(1)) {
                TMap _map176 = iprot.readMapBegin((byte)11, (byte)11);
                struct.attributes = new HashMap<ByteBuffer, ByteBuffer>(2 * _map176.size);
                for (int _i179 = 0; _i179 < _map176.size; ++_i179) {
                    ByteBuffer _key177 = iprot.readBinary();
                    ByteBuffer _val178 = iprot.readBinary();
                    struct.attributes.put(_key177, _val178);
                }
                struct.setAttributesIsSet(true);
            }
            if (incoming.get(2)) {
                struct.durability = TDurability.findByValue(iprot.readI32());
                struct.setDurabilityIsSet(true);
            }
        }
    }

    private static class TTableDescriptorTupleSchemeFactory
    implements SchemeFactory {
        private TTableDescriptorTupleSchemeFactory() {
        }

        public TTableDescriptorTupleScheme getScheme() {
            return new TTableDescriptorTupleScheme();
        }
    }

    private static class TTableDescriptorStandardScheme
    extends StandardScheme<TTableDescriptor> {
        private TTableDescriptorStandardScheme() {
        }

        public void read(TProtocol iprot, TTableDescriptor struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.tableName = new TTableName();
                            struct.tableName.read(iprot);
                            struct.setTableNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list162 = iprot.readListBegin();
                            struct.columns = new ArrayList<TColumnFamilyDescriptor>(_list162.size);
                            for (int _i164 = 0; _i164 < _list162.size; ++_i164) {
                                TColumnFamilyDescriptor _elem163 = new TColumnFamilyDescriptor();
                                _elem163.read(iprot);
                                struct.columns.add(_elem163);
                            }
                            iprot.readListEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 13) {
                            TMap _map165 = iprot.readMapBegin();
                            struct.attributes = new HashMap<ByteBuffer, ByteBuffer>(2 * _map165.size);
                            for (int _i168 = 0; _i168 < _map165.size; ++_i168) {
                                ByteBuffer _key166 = iprot.readBinary();
                                ByteBuffer _val167 = iprot.readBinary();
                                struct.attributes.put(_key166, _val167);
                            }
                            iprot.readMapEnd();
                            struct.setAttributesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.durability = TDurability.findByValue(iprot.readI32());
                            struct.setDurabilityIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TTableDescriptor struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.tableName != null) {
                oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                struct.tableName.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.columns != null && struct.isSetColumns()) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.columns.size()));
                for (TColumnFamilyDescriptor tColumnFamilyDescriptor : struct.columns) {
                    tColumnFamilyDescriptor.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.attributes != null && struct.isSetAttributes()) {
                oprot.writeFieldBegin(ATTRIBUTES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.attributes.size()));
                for (Map.Entry entry : struct.attributes.entrySet()) {
                    oprot.writeBinary((ByteBuffer)entry.getKey());
                    oprot.writeBinary((ByteBuffer)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.durability != null && struct.isSetDurability()) {
                oprot.writeFieldBegin(DURABILITY_FIELD_DESC);
                oprot.writeI32(struct.durability.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TTableDescriptorStandardSchemeFactory
    implements SchemeFactory {
        private TTableDescriptorStandardSchemeFactory() {
        }

        public TTableDescriptorStandardScheme getScheme() {
            return new TTableDescriptorStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLE_NAME(1, "tableName"),
        COLUMNS(2, "columns"),
        ATTRIBUTES(3, "attributes"),
        DURABILITY(4, "durability");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLE_NAME;
                }
                case 2: {
                    return COLUMNS;
                }
                case 3: {
                    return ATTRIBUTES;
                }
                case 4: {
                    return DURABILITY;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

