/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestBidirectionSerialReplicationStuck
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBidirectionSerialReplicationStuck.class);

    @Override
    protected boolean isSerialPeer() {
        return true;
    }

    @Override
    public void setUpBase() throws Exception {
        UTIL1.ensureSomeRegionServersAvailable(2);
        hbaseAdmin.balancerSwitch(false, true);
        this.addPeer("2", tableName, UTIL1, UTIL2);
        this.addPeer("2", tableName, UTIL2, UTIL1);
    }

    @Override
    public void tearDownBase() throws Exception {
        this.removePeer("2", UTIL1);
        this.removePeer("2", UTIL2);
    }

    @Test
    public void testStuck() throws Exception {
        hbaseAdmin.disableReplicationPeer("2");
        byte[] qualifier = Bytes.toBytes((String)"q");
        htable1.put(new Put(Bytes.toBytes((String)"aaa-1")).addColumn(famName, qualifier, Bytes.toBytes((int)1)));
        htable2.put(new Put(Bytes.toBytes((String)"aaa-2")).addColumn(famName, qualifier, Bytes.toBytes((int)2)));
        UTIL1.waitFor(30000L, () -> htable1.exists(new Get(Bytes.toBytes((String)"aaa-2"))));
        UTIL1.getRSForFirstRegionInTable(tableName).abort("for testing");
        UTIL1.waitFor(30000L, () -> htable1.exists(new Get(Bytes.toBytes((String)"aaa-2"))));
        htable1.put(new Put(Bytes.toBytes((String)"aaa-3")).addColumn(famName, qualifier, Bytes.toBytes((int)3)));
        hbaseAdmin.enableReplicationPeer("2");
        UTIL1.waitFor(30000L, () -> htable2.exists(new Get(Bytes.toBytes((String)"aaa-3"))));
    }
}

