/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAsTable;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMinorCompaction {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMinorCompaction.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Configuration CONF = UTIL.getConfiguration();
    private HRegion r = null;
    private TableDescriptor htd = null;
    private static int COMPACTION_THRESHOLD;
    private static byte[] FIRST_ROW_BYTES;
    private static byte[] SECOND_ROW_BYTES;
    private static byte[] THIRD_ROW_BYTES;
    private static byte[] COL1;
    private static byte[] COL2;

    @BeforeClass
    public static void setUpBeforeClass() {
        CONF.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        CONF.setInt("hbase.hregion.memstore.block.multiplier", 100);
        COMPACTION_THRESHOLD = CONF.getInt("hbase.hstore.compactionThreshold", 3);
        CONF.setClass("hbase.hstore.defaultengine.compactionpolicy.class", MyCompactionPolicy.class, RatioBasedCompactionPolicy.class);
        FIRST_ROW_BYTES = HBaseTestingUtility.START_KEY_BYTES;
        SECOND_ROW_BYTES = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        int n = HBaseTestingUtility.START_KEY_BYTES.length - 1;
        SECOND_ROW_BYTES[n] = (byte)(SECOND_ROW_BYTES[n] + 1);
        THIRD_ROW_BYTES = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        TestMinorCompaction.THIRD_ROW_BYTES[HBaseTestingUtility.START_KEY_BYTES.length - 1] = (byte)(THIRD_ROW_BYTES[HBaseTestingUtility.START_KEY_BYTES.length - 1] + 2);
        COL1 = Bytes.toBytes((String)"column1");
        COL2 = Bytes.toBytes((String)"column2");
    }

    @Before
    public void setUp() throws Exception {
        this.htd = UTIL.createTableDescriptor(this.name.getMethodName());
        this.r = UTIL.createLocalHRegion(this.htd, null, null);
    }

    @After
    public void tearDown() throws Exception {
        WAL wal = this.r.getWAL();
        this.r.close();
        wal.close();
    }

    @Test
    public void testMinorCompactionWithDeleteRow() throws Exception {
        Delete deleteRow = new Delete(SECOND_ROW_BYTES);
        this.testMinorCompactionWithDelete(deleteRow);
    }

    @Test
    public void testMinorCompactionWithDeleteColumn1() throws Exception {
        Delete dc = new Delete(SECOND_ROW_BYTES);
        dc.addColumns(HBaseTestingUtility.fam2, COL2);
        this.testMinorCompactionWithDelete(dc);
    }

    @Test
    public void testMinorCompactionWithDeleteColumn2() throws Exception {
        Delete dc = new Delete(SECOND_ROW_BYTES);
        dc.addColumn(HBaseTestingUtility.fam2, COL2);
        this.testMinorCompactionWithDelete(dc, 3);
    }

    @Test
    public void testMinorCompactionWithDeleteColumnFamily() throws Exception {
        Delete deleteCF = new Delete(SECOND_ROW_BYTES);
        deleteCF.addFamily(HBaseTestingUtility.fam2);
        this.testMinorCompactionWithDelete(deleteCF);
    }

    @Test
    public void testMinorCompactionWithDeleteVersion1() throws Exception {
        Delete deleteVersion = new Delete(SECOND_ROW_BYTES);
        deleteVersion.addColumns(HBaseTestingUtility.fam2, COL2, 2L);
        this.testMinorCompactionWithDelete(deleteVersion, 1);
    }

    @Test
    public void testMinorCompactionWithDeleteVersion2() throws Exception {
        Delete deleteVersion = new Delete(SECOND_ROW_BYTES);
        deleteVersion.addColumn(HBaseTestingUtility.fam2, COL2, 1L);
        this.testMinorCompactionWithDelete(deleteVersion, 3);
    }

    private void testMinorCompactionWithDelete(Delete delete) throws Exception {
        this.testMinorCompactionWithDelete(delete, 0);
    }

    private void testMinorCompactionWithDelete(Delete delete, int expectedResultsAfterDelete) throws Exception {
        RegionAsTable loader = new RegionAsTable((Region)this.r);
        for (int i = 0; i < COMPACTION_THRESHOLD + 1; ++i) {
            HTestConst.addContent(loader, Bytes.toString((byte[])HBaseTestingUtility.fam1), Bytes.toString((byte[])COL1), FIRST_ROW_BYTES, THIRD_ROW_BYTES, i);
            HTestConst.addContent(loader, Bytes.toString((byte[])HBaseTestingUtility.fam1), Bytes.toString((byte[])COL2), FIRST_ROW_BYTES, THIRD_ROW_BYTES, i);
            HTestConst.addContent(loader, Bytes.toString((byte[])HBaseTestingUtility.fam2), Bytes.toString((byte[])COL1), FIRST_ROW_BYTES, THIRD_ROW_BYTES, i);
            HTestConst.addContent(loader, Bytes.toString((byte[])HBaseTestingUtility.fam2), Bytes.toString((byte[])COL2), FIRST_ROW_BYTES, THIRD_ROW_BYTES, i);
            this.r.flush(true);
        }
        Result result = this.r.get(new Get(FIRST_ROW_BYTES).addColumn(HBaseTestingUtility.fam1, COL1).readVersions(100));
        Assert.assertEquals((long)COMPACTION_THRESHOLD, (long)result.size());
        result = this.r.get(new Get(SECOND_ROW_BYTES).addColumn(HBaseTestingUtility.fam2, COL2).readVersions(100));
        Assert.assertEquals((long)COMPACTION_THRESHOLD, (long)result.size());
        this.r.delete(delete);
        result = this.r.get(new Get(SECOND_ROW_BYTES).addColumn(HBaseTestingUtility.fam2, COL2).readVersions(100));
        Assert.assertEquals((long)expectedResultsAfterDelete, (long)result.size());
        result = this.r.get(new Get(FIRST_ROW_BYTES).addColumn(HBaseTestingUtility.fam1, COL1).readVersions(100));
        Assert.assertEquals((long)COMPACTION_THRESHOLD, (long)result.size());
        this.r.flush(true);
        result = this.r.get(new Get(SECOND_ROW_BYTES).addColumn(HBaseTestingUtility.fam2, COL2).readVersions(100));
        Assert.assertEquals((long)expectedResultsAfterDelete, (long)result.size());
        result = this.r.get(new Get(FIRST_ROW_BYTES).addColumn(HBaseTestingUtility.fam1, COL1).readVersions(100));
        Assert.assertEquals((long)COMPACTION_THRESHOLD, (long)result.size());
        HStore store2 = this.r.getStore(HBaseTestingUtility.fam2);
        int numFiles1 = store2.getStorefiles().size();
        Assert.assertTrue((String)"Was expecting to see 4 store files", (numFiles1 > COMPACTION_THRESHOLD ? 1 : 0) != 0);
        Optional compaction = store2.requestCompaction();
        Assert.assertTrue((boolean)compaction.isPresent());
        store2.compact((CompactionContext)compaction.get(), (ThroughputController)NoLimitThroughputController.INSTANCE, null);
        int numFiles2 = store2.getStorefiles().size();
        Assert.assertTrue((String)"Number of store files should go down", (numFiles1 > numFiles2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Was not supposed to be a major compaction", (numFiles2 > 1 ? 1 : 0) != 0);
        result = this.r.get(new Get(SECOND_ROW_BYTES).addColumn(HBaseTestingUtility.fam2, COL2).readVersions(100));
        Assert.assertEquals((long)expectedResultsAfterDelete, (long)result.size());
        result = this.r.get(new Get(FIRST_ROW_BYTES).addColumn(HBaseTestingUtility.fam1, COL1).readVersions(100));
        Assert.assertEquals((long)COMPACTION_THRESHOLD, (long)result.size());
    }

    public static final class MyCompactionPolicy
    extends RatioBasedCompactionPolicy {
        public MyCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) {
            super(conf, storeConfigInfo);
        }

        public CompactionRequestImpl selectCompaction(Collection<HStoreFile> candidateFiles, List<HStoreFile> filesCompacting, boolean isUserCompaction, boolean mayUseOffPeak, boolean forceMajor) throws IOException {
            return new CompactionRequestImpl((Collection)candidateFiles.stream().filter(f -> !filesCompacting.contains(f)).limit(COMPACTION_THRESHOLD).collect(Collectors.toList()));
        }
    }
}

