/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.balancer.LoadBalancerFactory;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.base.Stopwatch;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Option;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class LoadBalancerPerformanceEvaluation
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger((String)LoadBalancerPerformanceEvaluation.class.getName());
    protected static final HBaseCommonTestingUtility UTIL = new HBaseCommonTestingUtility();
    private static final int DEFAULT_NUM_REGIONS = 1000000;
    private static Option NUM_REGIONS_OPT = new Option("regions", true, "Number of regions to consider by load balancer. Default: 1000000");
    private static final int DEFAULT_NUM_SERVERS = 1000;
    private static Option NUM_SERVERS_OPT = new Option("servers", true, "Number of servers to consider by load balancer. Default: 1000");
    private static final String DEFAULT_LOAD_BALANCER = "org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer";
    private static Option LOAD_BALANCER_OPT = new Option("load_balancer", true, "Type of Load Balancer to use. Default: org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer");
    private int numRegions;
    private int numServers;
    private String loadBalancerType;
    private Class<?> loadBalancerClazz;
    private LoadBalancer loadBalancer;
    private List<ServerName> servers;
    private List<RegionInfo> regions;
    private Map<RegionInfo, ServerName> regionServerMap;
    private Map<TableName, Map<ServerName, List<RegionInfo>>> tableServerRegionMap;

    private void setupConf() {
        this.conf.setClass("hbase.master.loadbalancer.class", this.loadBalancerClazz, LoadBalancer.class);
        this.loadBalancer = LoadBalancerFactory.getLoadBalancer((Configuration)this.conf);
    }

    private void generateRegionsAndServers() {
        TableName tableName = TableName.valueOf((String)"LoadBalancerPerfTable");
        this.regions = new ArrayList<RegionInfo>(this.numRegions);
        this.regionServerMap = new HashMap<RegionInfo, ServerName>(this.numRegions);
        for (int i = 0; i < this.numRegions; ++i) {
            byte[] start = new byte[16];
            byte[] end = new byte[16];
            Bytes.putInt((byte[])start, (int)0, (int)i);
            Bytes.putInt((byte[])end, (int)0, (int)(i + 1));
            RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(start).setEndKey(end).setSplit(false).setRegionId((long)i).build();
            this.regions.add(hri);
            this.regionServerMap.put(hri, null);
        }
        this.servers = new ArrayList<ServerName>(this.numServers);
        HashMap serverRegionMap = new HashMap(this.numServers);
        for (int i = 0; i < this.numServers; ++i) {
            ServerName sn = ServerName.valueOf((String)("srv" + i), (int)16020, (long)i);
            this.servers.add(sn);
            serverRegionMap.put(sn, i == 0 ? this.regions : Collections.emptyList());
        }
        this.tableServerRegionMap = Collections.singletonMap(tableName, serverRegionMap);
    }

    protected void addOptions() {
        this.addOption(NUM_REGIONS_OPT);
        this.addOption(NUM_SERVERS_OPT);
        this.addOption(LOAD_BALANCER_OPT);
    }

    protected void processOptions(CommandLine cmd) {
        this.numRegions = this.getOptionAsInt(cmd, NUM_REGIONS_OPT.getOpt(), 1000000);
        Preconditions.checkArgument((this.numRegions > 0 ? 1 : 0) != 0, (Object)"Invalid number of regions!");
        this.numServers = this.getOptionAsInt(cmd, NUM_SERVERS_OPT.getOpt(), 1000);
        Preconditions.checkArgument((this.numServers > 0 ? 1 : 0) != 0, (Object)"Invalid number of servers!");
        this.loadBalancerType = cmd.getOptionValue(LOAD_BALANCER_OPT.getOpt(), DEFAULT_LOAD_BALANCER);
        Preconditions.checkArgument((!this.loadBalancerType.isEmpty() ? 1 : 0) != 0, (Object)"Invalid load balancer type!");
        try {
            this.loadBalancerClazz = Class.forName(this.loadBalancerType);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class '" + this.loadBalancerType + "' not found!");
            System.exit(1);
        }
        this.setupConf();
    }

    private String formatResults(String methodName, long timeMillis) {
        return String.format("Time for %-25s: %dms%n", methodName, timeMillis);
    }

    protected int doWork() throws Exception {
        this.generateRegionsAndServers();
        String methodName = "roundRobinAssignment";
        LOG.info("Calling " + methodName);
        Stopwatch watch = Stopwatch.createStarted();
        this.loadBalancer.roundRobinAssignment(this.regions, this.servers);
        System.out.print(this.formatResults(methodName, watch.elapsed(TimeUnit.MILLISECONDS)));
        methodName = "retainAssignment";
        LOG.info("Calling " + methodName);
        watch.reset().start();
        this.loadBalancer.retainAssignment(this.regionServerMap, this.servers);
        System.out.print(this.formatResults(methodName, watch.elapsed(TimeUnit.MILLISECONDS)));
        methodName = "balanceCluster";
        LOG.info("Calling " + methodName);
        watch.reset().start();
        this.loadBalancer.balanceCluster(this.tableServerRegionMap);
        System.out.print(this.formatResults(methodName, watch.elapsed(TimeUnit.MILLISECONDS)));
        return 0;
    }

    public static void main(String[] args) throws IOException {
        LoadBalancerPerformanceEvaluation tool = new LoadBalancerPerformanceEvaluation();
        tool.setConf(UTIL.getConfiguration());
        tool.run(args);
    }
}

