/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.ColumnValueFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestParseFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestParseFilter.class);
    ParseFilter f;
    Filter filter;

    @Before
    public void setUp() throws Exception {
        this.f = new ParseFilter();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testKeyOnlyFilter() throws IOException {
        String filterString = "KeyOnlyFilter()";
        this.doTestFilter(filterString, KeyOnlyFilter.class);
        String filterString2 = "KeyOnlyFilter ('') ";
        byte[] filterStringAsByteArray2 = Bytes.toBytes((String)filterString2);
        try {
            this.filter = this.f.parseFilterString(filterStringAsByteArray2);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testFirstKeyOnlyFilter() throws IOException {
        String filterString = " FirstKeyOnlyFilter( ) ";
        this.doTestFilter(filterString, FirstKeyOnlyFilter.class);
        String filterString2 = " FirstKeyOnlyFilter ('') ";
        byte[] filterStringAsByteArray2 = Bytes.toBytes((String)filterString2);
        try {
            this.filter = this.f.parseFilterString(filterStringAsByteArray2);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testPrefixFilter() throws IOException {
        String filterString = " PrefixFilter('row' ) ";
        PrefixFilter prefixFilter = this.doTestFilter(filterString, PrefixFilter.class);
        byte[] prefix = prefixFilter.getPrefix();
        Assert.assertEquals((Object)"row", (Object)new String(prefix, StandardCharsets.UTF_8));
        filterString = " PrefixFilter(row)";
        try {
            this.doTestFilter(filterString, PrefixFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testColumnPrefixFilter() throws IOException {
        String filterString = " ColumnPrefixFilter('qualifier' ) ";
        ColumnPrefixFilter columnPrefixFilter = this.doTestFilter(filterString, ColumnPrefixFilter.class);
        byte[] columnPrefix = columnPrefixFilter.getPrefix();
        Assert.assertEquals((Object)"qualifier", (Object)new String(columnPrefix, StandardCharsets.UTF_8));
    }

    @Test
    public void testMultipleColumnPrefixFilter() throws IOException {
        String filterString = " MultipleColumnPrefixFilter('qualifier1', 'qualifier2' ) ";
        MultipleColumnPrefixFilter multipleColumnPrefixFilter = this.doTestFilter(filterString, MultipleColumnPrefixFilter.class);
        byte[][] prefixes = multipleColumnPrefixFilter.getPrefix();
        Assert.assertEquals((Object)"qualifier1", (Object)new String(prefixes[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"qualifier2", (Object)new String(prefixes[1], StandardCharsets.UTF_8));
    }

    @Test
    public void testColumnCountGetFilter() throws IOException {
        String filterString = " ColumnCountGetFilter(4)";
        ColumnCountGetFilter columnCountGetFilter = this.doTestFilter(filterString, ColumnCountGetFilter.class);
        int limit = columnCountGetFilter.getLimit();
        Assert.assertEquals((long)4L, (long)limit);
        filterString = " ColumnCountGetFilter('abc')";
        try {
            this.doTestFilter(filterString, ColumnCountGetFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
        filterString = " ColumnCountGetFilter(2147483648)";
        try {
            this.doTestFilter(filterString, ColumnCountGetFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testPageFilter() throws IOException {
        String filterString = " PageFilter(4)";
        PageFilter pageFilter = this.doTestFilter(filterString, PageFilter.class);
        long pageSize = pageFilter.getPageSize();
        Assert.assertEquals((long)4L, (long)pageSize);
        filterString = " PageFilter('123')";
        try {
            this.doTestFilter(filterString, PageFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("PageFilter needs an int as an argument");
        }
    }

    @Test
    public void testColumnPaginationFilter() throws IOException {
        String filterString = "ColumnPaginationFilter(4, 6)";
        ColumnPaginationFilter columnPaginationFilter = this.doTestFilter(filterString, ColumnPaginationFilter.class);
        int limit = columnPaginationFilter.getLimit();
        Assert.assertEquals((long)4L, (long)limit);
        int offset = columnPaginationFilter.getOffset();
        Assert.assertEquals((long)6L, (long)offset);
        filterString = " ColumnPaginationFilter('124')";
        try {
            this.doTestFilter(filterString, ColumnPaginationFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("ColumnPaginationFilter needs two arguments");
        }
        filterString = " ColumnPaginationFilter('4' , '123a')";
        try {
            this.doTestFilter(filterString, ColumnPaginationFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("ColumnPaginationFilter needs two ints as arguments");
        }
        filterString = " ColumnPaginationFilter('4' , '-123')";
        try {
            this.doTestFilter(filterString, ColumnPaginationFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("ColumnPaginationFilter arguments should not be negative");
        }
    }

    @Test
    public void testInclusiveStopFilter() throws IOException {
        String filterString = "InclusiveStopFilter ('row 3')";
        InclusiveStopFilter inclusiveStopFilter = this.doTestFilter(filterString, InclusiveStopFilter.class);
        byte[] stopRowKey = inclusiveStopFilter.getStopRowKey();
        Assert.assertEquals((Object)"row 3", (Object)new String(stopRowKey, StandardCharsets.UTF_8));
    }

    @Test
    public void testTimestampsFilter() throws IOException {
        String filterString = "TimestampsFilter(9223372036854775806, 6)";
        TimestampsFilter timestampsFilter = this.doTestFilter(filterString, TimestampsFilter.class);
        List timestamps = timestampsFilter.getTimestamps();
        Assert.assertEquals((long)2L, (long)timestamps.size());
        Assert.assertEquals((Object)6L, timestamps.get(0));
        filterString = "TimestampsFilter()";
        timestampsFilter = this.doTestFilter(filterString, TimestampsFilter.class);
        timestamps = timestampsFilter.getTimestamps();
        Assert.assertEquals((long)0L, (long)timestamps.size());
        filterString = "TimestampsFilter(9223372036854775808, 6)";
        try {
            this.doTestFilter(filterString, ColumnPaginationFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Long Argument was too large");
        }
        filterString = "TimestampsFilter(-45, 6)";
        try {
            this.doTestFilter(filterString, ColumnPaginationFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Timestamp Arguments should not be negative");
        }
    }

    @Test
    public void testRowFilter() throws IOException {
        String filterString = "RowFilter ( =,   'binary:regionse')";
        RowFilter rowFilter = this.doTestFilter(filterString, RowFilter.class);
        Assert.assertEquals((Object)CompareOperator.EQUAL, (Object)rowFilter.getCompareOperator());
        Assert.assertTrue((boolean)(rowFilter.getComparator() instanceof BinaryComparator));
        BinaryComparator binaryComparator = (BinaryComparator)rowFilter.getComparator();
        Assert.assertEquals((Object)"regionse", (Object)new String(binaryComparator.getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testFamilyFilter() throws IOException {
        String filterString = "FamilyFilter(>=, 'binaryprefix:pre')";
        FamilyFilter familyFilter = this.doTestFilter(filterString, FamilyFilter.class);
        Assert.assertEquals((Object)CompareOperator.GREATER_OR_EQUAL, (Object)familyFilter.getCompareOperator());
        Assert.assertTrue((boolean)(familyFilter.getComparator() instanceof BinaryPrefixComparator));
        BinaryPrefixComparator binaryPrefixComparator = (BinaryPrefixComparator)familyFilter.getComparator();
        Assert.assertEquals((Object)"pre", (Object)new String(binaryPrefixComparator.getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testQualifierFilter() throws IOException {
        String filterString = "QualifierFilter(=, 'regexstring:pre*')";
        QualifierFilter qualifierFilter = this.doTestFilter(filterString, QualifierFilter.class);
        Assert.assertEquals((Object)CompareOperator.EQUAL, (Object)qualifierFilter.getCompareOperator());
        Assert.assertTrue((boolean)(qualifierFilter.getComparator() instanceof RegexStringComparator));
        RegexStringComparator regexStringComparator = (RegexStringComparator)qualifierFilter.getComparator();
        Assert.assertEquals((Object)"pre*", (Object)new String(regexStringComparator.getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testQualifierFilterNoCase() throws IOException {
        String filterString = "QualifierFilter(=, 'regexstringnocase:pre*')";
        QualifierFilter qualifierFilter = this.doTestFilter(filterString, QualifierFilter.class);
        Assert.assertEquals((Object)CompareOperator.EQUAL, (Object)qualifierFilter.getCompareOperator());
        Assert.assertTrue((boolean)(qualifierFilter.getComparator() instanceof RegexStringComparator));
        RegexStringComparator regexStringComparator = (RegexStringComparator)qualifierFilter.getComparator();
        Assert.assertEquals((Object)"pre*", (Object)new String(regexStringComparator.getValue(), StandardCharsets.UTF_8));
        int regexComparatorFlags = regexStringComparator.getEngine().getFlags();
        Assert.assertEquals((long)34L, (long)regexComparatorFlags);
    }

    @Test
    public void testValueFilter() throws IOException {
        String filterString = "ValueFilter(!=, 'substring:pre')";
        ValueFilter valueFilter = this.doTestFilter(filterString, ValueFilter.class);
        Assert.assertEquals((Object)CompareOperator.NOT_EQUAL, (Object)valueFilter.getCompareOperator());
        Assert.assertTrue((boolean)(valueFilter.getComparator() instanceof SubstringComparator));
        SubstringComparator substringComparator = (SubstringComparator)valueFilter.getComparator();
        Assert.assertEquals((Object)"pre", (Object)new String(substringComparator.getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testColumnRangeFilter() throws IOException {
        String filterString = "ColumnRangeFilter('abc', true, 'xyz', false)";
        ColumnRangeFilter columnRangeFilter = this.doTestFilter(filterString, ColumnRangeFilter.class);
        Assert.assertEquals((Object)"abc", (Object)new String(columnRangeFilter.getMinColumn(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"xyz", (Object)new String(columnRangeFilter.getMaxColumn(), StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)columnRangeFilter.isMinColumnInclusive());
        Assert.assertFalse((boolean)columnRangeFilter.isMaxColumnInclusive());
    }

    @Test
    public void testDependentColumnFilter() throws IOException {
        String filterString = "DependentColumnFilter('family', 'qualifier', true, =, 'binary:abc')";
        DependentColumnFilter dependentColumnFilter = this.doTestFilter(filterString, DependentColumnFilter.class);
        Assert.assertEquals((Object)"family", (Object)new String(dependentColumnFilter.getFamily(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"qualifier", (Object)new String(dependentColumnFilter.getQualifier(), StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)dependentColumnFilter.getDropDependentColumn());
        Assert.assertEquals((Object)CompareOperator.EQUAL, (Object)dependentColumnFilter.getCompareOperator());
        Assert.assertTrue((boolean)(dependentColumnFilter.getComparator() instanceof BinaryComparator));
        BinaryComparator binaryComparator = (BinaryComparator)dependentColumnFilter.getComparator();
        Assert.assertEquals((Object)"abc", (Object)new String(binaryComparator.getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testSingleColumnValueFilter() throws IOException {
        String filterString = "SingleColumnValueFilter ('family', 'qualifier', >=, 'binary:a', true, false)";
        SingleColumnValueFilter singleColumnValueFilter = this.doTestFilter(filterString, SingleColumnValueFilter.class);
        Assert.assertEquals((Object)"family", (Object)new String(singleColumnValueFilter.getFamily(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"qualifier", (Object)new String(singleColumnValueFilter.getQualifier(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)CompareOperator.GREATER_OR_EQUAL, (Object)singleColumnValueFilter.getCompareOperator());
        Assert.assertTrue((boolean)(singleColumnValueFilter.getComparator() instanceof BinaryComparator));
        BinaryComparator binaryComparator = (BinaryComparator)singleColumnValueFilter.getComparator();
        Assert.assertEquals((Object)"a", (Object)new String(binaryComparator.getValue(), StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)singleColumnValueFilter.getFilterIfMissing());
        Assert.assertFalse((boolean)singleColumnValueFilter.getLatestVersionOnly());
        filterString = "SingleColumnValueFilter ('family', 'qualifier', >, 'binaryprefix:a')";
        singleColumnValueFilter = this.doTestFilter(filterString, SingleColumnValueFilter.class);
        Assert.assertEquals((Object)"family", (Object)new String(singleColumnValueFilter.getFamily(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"qualifier", (Object)new String(singleColumnValueFilter.getQualifier(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)CompareOperator.GREATER, (Object)singleColumnValueFilter.getCompareOperator());
        Assert.assertTrue((boolean)(singleColumnValueFilter.getComparator() instanceof BinaryPrefixComparator));
        BinaryPrefixComparator binaryPrefixComparator = (BinaryPrefixComparator)singleColumnValueFilter.getComparator();
        Assert.assertEquals((Object)"a", (Object)new String(binaryPrefixComparator.getValue(), StandardCharsets.UTF_8));
        Assert.assertFalse((boolean)singleColumnValueFilter.getFilterIfMissing());
        Assert.assertTrue((boolean)singleColumnValueFilter.getLatestVersionOnly());
    }

    @Test
    public void testSingleColumnValueExcludeFilter() throws IOException {
        String filterString = "SingleColumnValueExcludeFilter ('family', 'qualifier', <, 'binaryprefix:a')";
        SingleColumnValueExcludeFilter singleColumnValueExcludeFilter = this.doTestFilter(filterString, SingleColumnValueExcludeFilter.class);
        Assert.assertEquals((Object)CompareOperator.LESS, (Object)singleColumnValueExcludeFilter.getCompareOperator());
        Assert.assertEquals((Object)"family", (Object)new String(singleColumnValueExcludeFilter.getFamily(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"qualifier", (Object)new String(singleColumnValueExcludeFilter.getQualifier(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"a", (Object)new String(singleColumnValueExcludeFilter.getComparator().getValue(), StandardCharsets.UTF_8));
        Assert.assertFalse((boolean)singleColumnValueExcludeFilter.getFilterIfMissing());
        Assert.assertTrue((boolean)singleColumnValueExcludeFilter.getLatestVersionOnly());
        filterString = "SingleColumnValueExcludeFilter ('family', 'qualifier', <=, 'binaryprefix:a', true, false)";
        singleColumnValueExcludeFilter = this.doTestFilter(filterString, SingleColumnValueExcludeFilter.class);
        Assert.assertEquals((Object)"family", (Object)new String(singleColumnValueExcludeFilter.getFamily(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"qualifier", (Object)new String(singleColumnValueExcludeFilter.getQualifier(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)CompareOperator.LESS_OR_EQUAL, (Object)singleColumnValueExcludeFilter.getCompareOperator());
        Assert.assertTrue((boolean)(singleColumnValueExcludeFilter.getComparator() instanceof BinaryPrefixComparator));
        BinaryPrefixComparator binaryPrefixComparator = (BinaryPrefixComparator)singleColumnValueExcludeFilter.getComparator();
        Assert.assertEquals((Object)"a", (Object)new String(binaryPrefixComparator.getValue(), StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)singleColumnValueExcludeFilter.getFilterIfMissing());
        Assert.assertFalse((boolean)singleColumnValueExcludeFilter.getLatestVersionOnly());
    }

    @Test
    public void testSkipFilter() throws IOException {
        String filterString = "SKIP ValueFilter( =,  'binary:0')";
        SkipFilter skipFilter = this.doTestFilter(filterString, SkipFilter.class);
        Assert.assertTrue((boolean)(skipFilter.getFilter() instanceof ValueFilter));
        ValueFilter valueFilter = (ValueFilter)skipFilter.getFilter();
        Assert.assertEquals((Object)CompareOperator.EQUAL, (Object)valueFilter.getCompareOperator());
        Assert.assertTrue((boolean)(valueFilter.getComparator() instanceof BinaryComparator));
        BinaryComparator binaryComparator = (BinaryComparator)valueFilter.getComparator();
        Assert.assertEquals((Object)"0", (Object)new String(binaryComparator.getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testWhileFilter() throws IOException {
        String filterString = " WHILE   RowFilter ( !=, 'binary:row1')";
        WhileMatchFilter whileMatchFilter = this.doTestFilter(filterString, WhileMatchFilter.class);
        Assert.assertTrue((boolean)(whileMatchFilter.getFilter() instanceof RowFilter));
        RowFilter rowFilter = (RowFilter)whileMatchFilter.getFilter();
        Assert.assertEquals((Object)CompareOperator.NOT_EQUAL, (Object)rowFilter.getCompareOperator());
        Assert.assertTrue((boolean)(rowFilter.getComparator() instanceof BinaryComparator));
        BinaryComparator binaryComparator = (BinaryComparator)rowFilter.getComparator();
        Assert.assertEquals((Object)"row1", (Object)new String(binaryComparator.getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testCompoundFilter1() throws IOException {
        String filterString = " (PrefixFilter ('realtime')AND  FirstKeyOnlyFilter())";
        FilterList filterList = this.doTestFilter(filterString, FilterList.class);
        ArrayList filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof PrefixFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof FirstKeyOnlyFilter));
        PrefixFilter PrefixFilter2 = (PrefixFilter)filters.get(0);
        byte[] prefix = PrefixFilter2.getPrefix();
        Assert.assertEquals((Object)"realtime", (Object)new String(prefix, StandardCharsets.UTF_8));
        FirstKeyOnlyFilter firstKeyOnlyFilter = (FirstKeyOnlyFilter)filters.get(1);
    }

    @Test
    public void testCompoundFilter2() throws IOException {
        String filterString = "(PrefixFilter('realtime') AND QualifierFilter (>=, 'binary:e'))OR FamilyFilter (=, 'binary:qualifier') ";
        FilterList filterList = this.doTestFilter(filterString, FilterList.class);
        ArrayList filterListFilters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filterListFilters.get(0) instanceof FilterList));
        Assert.assertTrue((boolean)(filterListFilters.get(1) instanceof FamilyFilter));
        Assert.assertEquals((Object)FilterList.Operator.MUST_PASS_ONE, (Object)filterList.getOperator());
        filterList = (FilterList)filterListFilters.get(0);
        FamilyFilter familyFilter = (FamilyFilter)filterListFilters.get(1);
        filterListFilters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filterListFilters.get(0) instanceof PrefixFilter));
        Assert.assertTrue((boolean)(filterListFilters.get(1) instanceof QualifierFilter));
        Assert.assertEquals((Object)FilterList.Operator.MUST_PASS_ALL, (Object)filterList.getOperator());
        Assert.assertEquals((Object)CompareOperator.EQUAL, (Object)familyFilter.getCompareOperator());
        Assert.assertTrue((boolean)(familyFilter.getComparator() instanceof BinaryComparator));
        BinaryComparator binaryComparator = (BinaryComparator)familyFilter.getComparator();
        Assert.assertEquals((Object)"qualifier", (Object)new String(binaryComparator.getValue(), StandardCharsets.UTF_8));
        PrefixFilter prefixFilter = (PrefixFilter)filterListFilters.get(0);
        byte[] prefix = prefixFilter.getPrefix();
        Assert.assertEquals((Object)"realtime", (Object)new String(prefix, StandardCharsets.UTF_8));
        QualifierFilter qualifierFilter = (QualifierFilter)filterListFilters.get(1);
        Assert.assertEquals((Object)CompareOperator.GREATER_OR_EQUAL, (Object)qualifierFilter.getCompareOperator());
        Assert.assertTrue((boolean)(qualifierFilter.getComparator() instanceof BinaryComparator));
        binaryComparator = (BinaryComparator)qualifierFilter.getComparator();
        Assert.assertEquals((Object)"e", (Object)new String(binaryComparator.getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testCompoundFilter3() throws IOException {
        String filterString = " ColumnPrefixFilter ('realtime')AND  FirstKeyOnlyFilter() OR SKIP FamilyFilter(=, 'substring:hihi')";
        FilterList filterList = this.doTestFilter(filterString, FilterList.class);
        ArrayList filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof FilterList));
        Assert.assertTrue((boolean)(filters.get(1) instanceof SkipFilter));
        filterList = (FilterList)filters.get(0);
        SkipFilter skipFilter = (SkipFilter)filters.get(1);
        filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof ColumnPrefixFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof FirstKeyOnlyFilter));
        ColumnPrefixFilter columnPrefixFilter = (ColumnPrefixFilter)filters.get(0);
        byte[] columnPrefix = columnPrefixFilter.getPrefix();
        Assert.assertEquals((Object)"realtime", (Object)new String(columnPrefix, StandardCharsets.UTF_8));
        FirstKeyOnlyFilter firstKeyOnlyFilter = (FirstKeyOnlyFilter)filters.get(1);
        Assert.assertTrue((boolean)(skipFilter.getFilter() instanceof FamilyFilter));
        FamilyFilter familyFilter = (FamilyFilter)skipFilter.getFilter();
        Assert.assertEquals((Object)CompareOperator.EQUAL, (Object)familyFilter.getCompareOperator());
        Assert.assertTrue((boolean)(familyFilter.getComparator() instanceof SubstringComparator));
        SubstringComparator substringComparator = (SubstringComparator)familyFilter.getComparator();
        Assert.assertEquals((Object)"hihi", (Object)new String(substringComparator.getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testCompoundFilter4() throws IOException {
        String filterString = " ColumnPrefixFilter ('realtime') OR FirstKeyOnlyFilter() OR SKIP FamilyFilter(=, 'substring:hihi')";
        FilterList filterList = this.doTestFilter(filterString, FilterList.class);
        ArrayList filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof ColumnPrefixFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof FirstKeyOnlyFilter));
        Assert.assertTrue((boolean)(filters.get(2) instanceof SkipFilter));
        ColumnPrefixFilter columnPrefixFilter = (ColumnPrefixFilter)filters.get(0);
        FirstKeyOnlyFilter firstKeyOnlyFilter = (FirstKeyOnlyFilter)filters.get(1);
        SkipFilter skipFilter = (SkipFilter)filters.get(2);
        byte[] columnPrefix = columnPrefixFilter.getPrefix();
        Assert.assertEquals((Object)"realtime", (Object)new String(columnPrefix, StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)(skipFilter.getFilter() instanceof FamilyFilter));
        FamilyFilter familyFilter = (FamilyFilter)skipFilter.getFilter();
        Assert.assertEquals((Object)CompareOperator.EQUAL, (Object)familyFilter.getCompareOperator());
        Assert.assertTrue((boolean)(familyFilter.getComparator() instanceof SubstringComparator));
        SubstringComparator substringComparator = (SubstringComparator)familyFilter.getComparator();
        Assert.assertEquals((Object)"hihi", (Object)new String(substringComparator.getValue(), StandardCharsets.UTF_8));
    }

    @Test
    public void testCompoundFilter5() throws IOException {
        String filterStr = "(ValueFilter(!=, 'substring:pre'))";
        ValueFilter valueFilter = this.doTestFilter(filterStr, ValueFilter.class);
        Assert.assertTrue((boolean)(valueFilter.getComparator() instanceof SubstringComparator));
        filterStr = "(ValueFilter(>=,'binary:x') AND (ValueFilter(<=,'binary:y'))) OR ValueFilter(=,'binary:ab')";
        this.filter = this.f.parseFilterString(filterStr);
        Assert.assertTrue((boolean)(this.filter instanceof FilterList));
        List list = ((FilterList)this.filter).getFilters();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof FilterList));
        Assert.assertTrue((boolean)(list.get(1) instanceof ValueFilter));
    }

    @Test
    public void testIncorrectCompareOperator() throws IOException {
        String filterString = "RowFilter ('>>' , 'binary:region')";
        try {
            this.doTestFilter(filterString, RowFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Incorrect compare operator >>");
        }
    }

    @Test
    public void testIncorrectComparatorType() throws IOException {
        String filterString = "RowFilter ('>=' , 'binaryoperator:region')";
        try {
            this.doTestFilter(filterString, RowFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Incorrect comparator type: binaryoperator");
        }
        filterString = "RowFilter ('>=' 'regexstring:pre*')";
        try {
            this.doTestFilter(filterString, RowFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("RegexStringComparator can only be used with EQUAL or NOT_EQUAL");
        }
        filterString = "SingleColumnValueFilter ('family', 'qualifier', '>=', 'substring:a', 'true', 'false')')";
        try {
            this.doTestFilter(filterString, RowFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("SubtringComparator can only be used with EQUAL or NOT_EQUAL");
        }
    }

    @Test
    public void testPrecedence1() throws IOException {
        String filterString = " (PrefixFilter ('realtime')AND  FirstKeyOnlyFilter() OR KeyOnlyFilter())";
        FilterList filterList = this.doTestFilter(filterString, FilterList.class);
        ArrayList filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof FilterList));
        Assert.assertTrue((boolean)(filters.get(1) instanceof KeyOnlyFilter));
        filterList = (FilterList)filters.get(0);
        filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof PrefixFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof FirstKeyOnlyFilter));
        PrefixFilter prefixFilter = (PrefixFilter)filters.get(0);
        byte[] prefix = prefixFilter.getPrefix();
        Assert.assertEquals((Object)"realtime", (Object)new String(prefix, StandardCharsets.UTF_8));
    }

    @Test
    public void testPrecedence2() throws IOException {
        String filterString = " PrefixFilter ('realtime')AND  SKIP FirstKeyOnlyFilter()OR KeyOnlyFilter()";
        FilterList filterList = this.doTestFilter(filterString, FilterList.class);
        ArrayList filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof FilterList));
        Assert.assertTrue((boolean)(filters.get(1) instanceof KeyOnlyFilter));
        filterList = (FilterList)filters.get(0);
        filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof PrefixFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof SkipFilter));
        PrefixFilter prefixFilter = (PrefixFilter)filters.get(0);
        byte[] prefix = prefixFilter.getPrefix();
        Assert.assertEquals((Object)"realtime", (Object)new String(prefix, StandardCharsets.UTF_8));
        SkipFilter skipFilter = (SkipFilter)filters.get(1);
        Assert.assertTrue((boolean)(skipFilter.getFilter() instanceof FirstKeyOnlyFilter));
    }

    @Test
    public void testUnescapedQuote1() throws IOException {
        String filterString = "InclusiveStopFilter ('row''3')";
        InclusiveStopFilter inclusiveStopFilter = this.doTestFilter(filterString, InclusiveStopFilter.class);
        byte[] stopRowKey = inclusiveStopFilter.getStopRowKey();
        Assert.assertEquals((Object)"row'3", (Object)new String(stopRowKey, StandardCharsets.UTF_8));
    }

    @Test
    public void testUnescapedQuote2() throws IOException {
        String filterString = "InclusiveStopFilter ('row''3''')";
        InclusiveStopFilter inclusiveStopFilter = this.doTestFilter(filterString, InclusiveStopFilter.class);
        byte[] stopRowKey = inclusiveStopFilter.getStopRowKey();
        Assert.assertEquals((Object)"row'3'", (Object)new String(stopRowKey, StandardCharsets.UTF_8));
    }

    @Test
    public void testUnescapedQuote3() throws IOException {
        String filterString = " InclusiveStopFilter ('''')";
        InclusiveStopFilter inclusiveStopFilter = this.doTestFilter(filterString, InclusiveStopFilter.class);
        byte[] stopRowKey = inclusiveStopFilter.getStopRowKey();
        Assert.assertEquals((Object)"'", (Object)new String(stopRowKey, StandardCharsets.UTF_8));
    }

    @Test
    public void testIncorrectFilterString() throws IOException {
        String filterString = "()";
        byte[] filterStringAsByteArray = Bytes.toBytes((String)filterString);
        try {
            this.filter = this.f.parseFilterString(filterStringAsByteArray);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testCorrectFilterString() throws IOException {
        String filterString = "(FirstKeyOnlyFilter())";
        FirstKeyOnlyFilter firstKeyOnlyFilter = this.doTestFilter(filterString, FirstKeyOnlyFilter.class);
    }

    @Test
    public void testRegisterFilter() {
        ParseFilter.registerFilter((String)"MyFilter", (String)"some.class");
        Assert.assertTrue((boolean)this.f.getSupportedFilters().contains("MyFilter"));
    }

    private <T extends Filter> T doTestFilter(String filterString, Class<T> clazz) throws IOException {
        byte[] filterStringAsByteArray = Bytes.toBytes((String)filterString);
        this.filter = this.f.parseFilterString(filterStringAsByteArray);
        Assert.assertEquals(clazz, this.filter.getClass());
        return (T)((Filter)clazz.cast(this.filter));
    }

    @Test
    public void testColumnValueFilter() throws IOException {
        String filterString = "ColumnValueFilter ('family', 'qualifier', <, 'binaryprefix:value')";
        ColumnValueFilter cvf = this.doTestFilter(filterString, ColumnValueFilter.class);
        Assert.assertEquals((Object)"family", (Object)new String(cvf.getFamily(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"qualifier", (Object)new String(cvf.getQualifier(), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)CompareOperator.LESS, (Object)cvf.getCompareOperator());
        Assert.assertTrue((boolean)(cvf.getComparator() instanceof BinaryPrefixComparator));
        Assert.assertEquals((Object)"value", (Object)new String(cvf.getComparator().getValue(), StandardCharsets.UTF_8));
    }
}

