/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationStringValue;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JType;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAnnotationUse
extends JAnnotationValue {
    private final JClass clazz;
    private Map<String, JAnnotationValue> memberValues;

    JAnnotationUse(JClass clazz) {
        this.clazz = clazz;
    }

    public JClass getAnnotationClass() {
        return this.clazz;
    }

    public Map<String, JAnnotationValue> getAnnotationMembers() {
        return Collections.unmodifiableMap(this.memberValues);
    }

    private JCodeModel owner() {
        return this.clazz.owner();
    }

    private void addValue(String name, JAnnotationValue annotationValue) {
        if (this.memberValues == null) {
            this.memberValues = new LinkedHashMap<String, JAnnotationValue>();
        }
        this.memberValues.put(name, annotationValue);
    }

    public JAnnotationUse param(String name, boolean value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, byte value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, char value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, double value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, float value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, long value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, short value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, int value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse param(String name, String value) {
        this.addValue(name, new JAnnotationStringValue(JExpr.lit(value)));
        return this;
    }

    public JAnnotationUse annotationParam(String name, Class<? extends Annotation> value) {
        JAnnotationUse annotationUse = new JAnnotationUse(this.owner().ref(value));
        this.addValue(name, annotationUse);
        return annotationUse;
    }

    public JAnnotationUse param(String name, final Enum<?> value) {
        this.addValue(name, new JAnnotationValue(){

            public void generate(JFormatter f) {
                f.t(JAnnotationUse.this.owner().ref(value.getDeclaringClass())).p('.').p(value.name());
            }
        });
        return this;
    }

    public JAnnotationUse param(String name, JEnumConstant value) {
        this.addValue(name, new JAnnotationStringValue(value));
        return this;
    }

    public JAnnotationUse param(String name, final Class<?> value) {
        this.addValue(name, new JAnnotationStringValue(new JExpressionImpl(){

            public void generate(JFormatter f) {
                f.p(value.getName().replace('$', '.'));
                f.p(".class");
            }
        }));
        return this;
    }

    public JAnnotationUse param(String name, JType type) {
        JClass c = type.boxify();
        this.addValue(name, new JAnnotationStringValue(c.dotclass()));
        return this;
    }

    public JAnnotationUse param(String name, JExpression value) {
        this.addValue(name, new JAnnotationStringValue(value));
        return this;
    }

    public JAnnotationArrayMember paramArray(String name) {
        JAnnotationArrayMember arrayMember = new JAnnotationArrayMember(this.owner());
        this.addValue(name, arrayMember);
        return arrayMember;
    }

    public JAnnotationUse annotate(Class<? extends Annotation> clazz) {
        JAnnotationUse annotationUse = new JAnnotationUse(this.owner().ref(clazz));
        return annotationUse;
    }

    @Override
    public void generate(JFormatter f) {
        f.p('@').g(this.clazz);
        if (this.memberValues != null) {
            f.p('(');
            boolean first = true;
            if (this.isOptimizable()) {
                f.g(this.memberValues.get("value"));
            } else {
                for (Map.Entry<String, JAnnotationValue> mapEntry : this.memberValues.entrySet()) {
                    if (!first) {
                        f.p(',');
                    }
                    f.p(mapEntry.getKey()).p('=').g(mapEntry.getValue());
                    first = false;
                }
            }
            f.p(')');
        }
    }

    private boolean isOptimizable() {
        return this.memberValues.size() == 1 && this.memberValues.containsKey("value");
    }
}

