/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionReplicaSplit {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicaSplit.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionReplicaSplit.class);
    private static final int NB_SERVERS = 4;
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private static final byte[] f = HConstants.CATALOG_FAMILY;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        HTU.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        HTU.startMiniCluster(4);
    }

    private static Table createTableAndLoadData(TableName tableName) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        builder.setRegionReplication(3);
        Table table = HTU.createTable(builder.build(), (byte[][])new byte[][]{f}, TestRegionReplicaSplit.getSplits(2), new Configuration(HTU.getConfiguration()));
        HTU.loadTable(HTU.getConnection().getTable(tableName), f);
        return table;
    }

    private static byte[][] getSplits(int numRegions) {
        RegionSplitter.UniformSplit split = new RegionSplitter.UniformSplit();
        split.setFirstRow(Bytes.toBytes((long)0L));
        split.setLastRow(Bytes.toBytes((long)Long.MAX_VALUE));
        return split.split(numRegions);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HRegionServer.TEST_SKIP_REPORTING_TRANSITION = false;
        HTU.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionReplicaSplitRegionAssignment() throws Exception {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        Table table = null;
        try {
            table = TestRegionReplicaSplit.createTableAndLoadData(tn);
            HTU.loadNumericRows(table, f, 0, 3);
            ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>();
            for (JVMClusterUtil.RegionServerThread rs : HTU.getMiniHBaseCluster().getRegionServerThreads()) {
                for (Region r : rs.getRegionServer().getRegions(table.getName())) {
                    regions.add(r.getRegionInfo());
                }
            }
            HTU.getAdmin().split(table.getName(), Bytes.toBytes((int)1));
            int count = 0;
            while (true) {
                for (JVMClusterUtil.RegionServerThread rs : HTU.getMiniHBaseCluster().getRegionServerThreads()) {
                    for (Region r : rs.getRegionServer().getRegions(table.getName())) {
                        ++count;
                    }
                }
                if (count >= 9) break;
                count = 0;
            }
            RegionReplicaTestHelper.assertReplicaDistributed(HTU, table);
        }
        finally {
            if (table != null) {
                HTU.deleteTable(tn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssignFakeReplicaRegion() throws Exception {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        Table table = null;
        try {
            table = TestRegionReplicaSplit.createTableAndLoadData(tn);
            RegionInfo fakeHri = RegionInfoBuilder.newBuilder((TableName)table.getName()).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"b")).setReplicaId(1).setRegionId(EnvironmentEdgeManager.currentTime()).build();
            HTU.getMiniHBaseCluster().getMaster().getAssignmentManager().assign(fakeHri);
            HBaseTestingUtility.await(50L, () -> HTU.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getActiveProcIds().isEmpty());
            for (JVMClusterUtil.RegionServerThread rs : HTU.getMiniHBaseCluster().getRegionServerThreads()) {
                for (Region r : rs.getRegionServer().getRegions(table.getName())) {
                    Assert.assertNotEquals((Object)r.getRegionInfo(), (Object)fakeHri);
                }
            }
        }
        finally {
            if (table != null) {
                HTU.deleteTable(tn);
            }
        }
    }
}

