/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSBuilder;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.functional.FutureIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FixedLengthRecordReader
extends RecordReader<LongWritable, BytesWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(FixedLengthRecordReader.class);
    private int recordLength;
    private long start;
    private long pos;
    private long end;
    private long numRecordsRemainingInSplit;
    private FSDataInputStream fileIn;
    private Seekable filePosition;
    private LongWritable key;
    private BytesWritable value;
    private boolean isCompressedInput;
    private Decompressor decompressor;
    private InputStream inputStream;

    public FixedLengthRecordReader(int recordLength) {
        this.recordLength = recordLength;
    }

    @Override
    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        FileSplit split = (FileSplit)genericSplit;
        Configuration job = context.getConfiguration();
        Path file = split.getPath();
        this.initialize(job, split.getStart(), split.getLength(), file);
    }

    public void initialize(Configuration job, long splitStart, long splitLength, Path file) throws IOException {
        this.start = splitStart;
        this.end = this.start + splitLength;
        long partialRecordLength = this.start % (long)this.recordLength;
        long numBytesToSkip = 0L;
        if (partialRecordLength != 0L) {
            numBytesToSkip = (long)this.recordLength - partialRecordLength;
        }
        FutureDataInputStreamBuilder builder = file.getFileSystem(job).openFile(file);
        FutureIO.propagateOptions((FSBuilder)builder, (Configuration)job, (String)"mapreduce.job.input.file.option.", (String)"mapreduce.job.input.file.must.");
        this.fileIn = (FSDataInputStream)FutureIO.awaitFuture((Future)builder.build());
        CompressionCodec codec = new CompressionCodecFactory(job).getCodec(file);
        if (null != codec) {
            this.isCompressedInput = true;
            this.decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
            CompressionInputStream cIn = codec.createInputStream((InputStream)this.fileIn, this.decompressor);
            this.filePosition = cIn;
            this.inputStream = cIn;
            this.numRecordsRemainingInSplit = Long.MAX_VALUE;
            LOG.info("Compressed input; cannot compute number of records in the split");
        } else {
            this.fileIn.seek(this.start);
            this.filePosition = this.fileIn;
            this.inputStream = this.fileIn;
            long splitSize = this.end - this.start - numBytesToSkip;
            this.numRecordsRemainingInSplit = (splitSize + (long)this.recordLength - 1L) / (long)this.recordLength;
            if (this.numRecordsRemainingInSplit < 0L) {
                this.numRecordsRemainingInSplit = 0L;
            }
            LOG.info("Expecting " + this.numRecordsRemainingInSplit + " records each with a length of " + this.recordLength + " bytes in the split with an effective size of " + splitSize + " bytes");
        }
        if (numBytesToSkip != 0L) {
            this.start += this.inputStream.skip(numBytesToSkip);
        }
        this.pos = this.start;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized boolean nextKeyValue() throws IOException {
        int numBytesToRead;
        if (this.key == null) {
            this.key = new LongWritable();
        }
        if (this.value == null) {
            this.value = new BytesWritable(new byte[this.recordLength]);
        }
        boolean dataRead = false;
        this.value.setSize(this.recordLength);
        byte[] record = this.value.getBytes();
        if (this.numRecordsRemainingInSplit <= 0L) return dataRead;
        this.key.set(this.pos);
        int offset = 0;
        int numBytesRead = 0;
        for (numBytesToRead = this.recordLength; numBytesToRead > 0 && (numBytesRead = this.inputStream.read(record, offset, numBytesToRead)) != -1; numBytesToRead -= numBytesRead) {
            offset += numBytesRead;
        }
        numBytesRead = this.recordLength - numBytesToRead;
        this.pos += (long)numBytesRead;
        if (numBytesRead > 0) {
            dataRead = true;
            if (numBytesRead < this.recordLength) throw new IOException("Partial record(length = " + numBytesRead + ") found at the end of split.");
            if (this.isCompressedInput) return dataRead;
            --this.numRecordsRemainingInSplit;
            return dataRead;
        } else {
            this.numRecordsRemainingInSplit = 0L;
        }
        return dataRead;
    }

    @Override
    public LongWritable getCurrentKey() {
        return this.key;
    }

    @Override
    public BytesWritable getCurrentValue() {
        return this.value;
    }

    @Override
    public synchronized float getProgress() throws IOException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getFilePosition() - this.start) / (float)(this.end - this.start));
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        finally {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
                this.decompressor = null;
            }
        }
    }

    public long getPos() {
        return this.pos;
    }

    private long getFilePosition() throws IOException {
        long retVal = this.isCompressedInput && null != this.filePosition ? this.filePosition.getPos() : this.pos;
        return retVal;
    }
}

