/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PluggableBlockingQueue;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.util.BoundedPriorityBlockingQueue;

public class TestPluggableQueueImpl
extends PluggableBlockingQueue
implements ConfigurationObserver {
    private final BoundedPriorityBlockingQueue<CallRunner> inner;
    private static boolean configurationRecentlyChanged = false;

    public TestPluggableQueueImpl(int maxQueueLength, PriorityFunction priority, Configuration conf) {
        super(maxQueueLength, priority, conf);
        Comparator<CallRunner> comparator = Comparator.comparingInt(r -> r.getRpcCall().getPriority());
        this.inner = new BoundedPriorityBlockingQueue(maxQueueLength, comparator);
        configurationRecentlyChanged = false;
    }

    public boolean add(CallRunner callRunner) {
        return this.inner.add((Object)callRunner);
    }

    public boolean offer(CallRunner callRunner) {
        return this.inner.offer((Object)callRunner);
    }

    public CallRunner remove() {
        return (CallRunner)this.inner.remove();
    }

    public CallRunner poll() {
        return (CallRunner)this.inner.poll();
    }

    public CallRunner element() {
        return (CallRunner)this.inner.element();
    }

    public CallRunner peek() {
        return (CallRunner)this.inner.peek();
    }

    public void put(CallRunner callRunner) throws InterruptedException {
        this.inner.put((Object)callRunner);
    }

    public boolean offer(CallRunner callRunner, long timeout, TimeUnit unit) throws InterruptedException {
        return this.inner.offer((Object)callRunner, timeout, unit);
    }

    public CallRunner take() throws InterruptedException {
        return (CallRunner)this.inner.take();
    }

    public CallRunner poll(long timeout, TimeUnit unit) throws InterruptedException {
        return (CallRunner)this.inner.poll(timeout, unit);
    }

    public int remainingCapacity() {
        return this.inner.remainingCapacity();
    }

    public boolean remove(Object o) {
        return this.inner.remove(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.inner.containsAll(c);
    }

    public boolean addAll(Collection<? extends CallRunner> c) {
        return this.inner.addAll(c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.inner.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.inner.retainAll(c);
    }

    public void clear() {
        this.inner.clear();
    }

    public int size() {
        return this.inner.size();
    }

    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public boolean contains(Object o) {
        return this.inner.contains(o);
    }

    public Iterator<CallRunner> iterator() {
        return this.inner.iterator();
    }

    public Object[] toArray() {
        return this.inner.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.inner.toArray((Object[])a);
    }

    public int drainTo(Collection<? super CallRunner> c) {
        return this.inner.drainTo(c);
    }

    public int drainTo(Collection<? super CallRunner> c, int maxElements) {
        return this.inner.drainTo(c, maxElements);
    }

    public static boolean hasObservedARecentConfigurationChange() {
        return configurationRecentlyChanged;
    }

    public void onConfigurationChange(Configuration conf) {
        configurationRecentlyChanged = true;
    }
}

