/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class CoprocessorConfigurationUtil {
    private CoprocessorConfigurationUtil() {
    }

    public static boolean checkConfigurationChange(Configuration oldConfig, Configuration newConfig, String ... configurationKey) {
        Preconditions.checkArgument((configurationKey != null ? 1 : 0) != 0, (Object)"Configuration Key(s) must be provided");
        boolean isConfigurationChange = false;
        for (String key : configurationKey) {
            String newValue;
            String oldValue = oldConfig.get(key);
            if (StringUtils.equalsIgnoreCase((CharSequence)oldValue, (CharSequence)(newValue = newConfig.get(key)))) continue;
            isConfigurationChange = true;
            break;
        }
        return isConfigurationChange;
    }
}

