/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Consumer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CompoundBloomFilter;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.NoOpIndexBlockEncoder;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.BloomFilter;
import org.apache.hadoop.hbase.util.BloomFilterUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Hash;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, LargeTests.class})
public class TestBytesReadServerSideScanMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBytesReadServerSideScanMetrics.class);
    @Rule
    public TestName name = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestBytesReadServerSideScanMetrics.class);
    private HBaseTestingUtility UTIL;
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    private static final byte[] CQ = Bytes.toBytes((String)"cq");
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    private static final byte[] ROW2 = Bytes.toBytes((String)"row2");
    private static final byte[] ROW3 = Bytes.toBytes((String)"row3");
    private static final byte[] ROW4 = Bytes.toBytes((String)"row4");
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.UTIL = new HBaseTestingUtility();
        this.conf = this.UTIL.getConfiguration();
        this.conf.setInt("hbase.regionserver.optionalcacheflushinterval", 0);
        this.conf.setBoolean("hbase.regionserver.compaction.enabled", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanMetricsDisabled() throws Exception {
        this.conf.setInt("hfile.block.cache.size", 0);
        this.UTIL.startMiniCluster();
        try {
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            this.createTable(tableName, false, BloomType.NONE);
            this.writeData(tableName, true);
            Scan scan = new Scan();
            scan.withStartRow(ROW2, true);
            scan.withStopRow(ROW4, true);
            scan.setCaching(1);
            try (Table table = this.UTIL.getConnection().getTable(tableName);
                 ResultScanner scanner = table.getScanner(scan);){
                int rowCount = 0;
                for (Result r : scanner) {
                    ++rowCount;
                }
                Assert.assertEquals((long)2L, (long)rowCount);
                Assert.assertNull((Object)scanner.getScanMetrics());
            }
        }
        finally {
            this.UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBytesReadFromFsForSerialSeeks() throws Exception {
        this.conf.setInt("hfile.block.cache.size", 0);
        this.UTIL.startMiniCluster();
        try {
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            this.createTable(tableName, false, BloomType.ROW);
            this.writeData(tableName, true);
            ScanMetrics scanMetrics = this.readDataAndGetScanMetrics(tableName, true);
            KeyValue keyValue = new KeyValue(ROW2, CF, CQ, Long.MIN_VALUE, VALUE);
            this.assertBytesReadFromFs(tableName, scanMetrics.bytesReadFromFs.get(), keyValue, scanMetrics.blockReadOpsCount.get());
            Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromBlockCache.get());
            Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromMemstore.get());
        }
        finally {
            this.UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBytesReadFromFsForParallelSeeks() throws Exception {
        this.conf.setInt("hfile.block.cache.size", 0);
        this.conf.setBoolean("hbase.storescanner.parallel.seek.enable", true);
        this.UTIL.startMiniCluster();
        try {
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            this.createTable(tableName, false, BloomType.NONE);
            this.writeData(tableName, true);
            HRegionServer server = this.UTIL.getMiniHBaseCluster().getRegionServer(0);
            ThreadPoolExecutor executor = server.getExecutorService().getExecutorThreadPool(ExecutorType.RS_PARALLEL_SEEK);
            long tasksCompletedBeforeRead = executor.getCompletedTaskCount();
            ScanMetrics scanMetrics = this.readDataAndGetScanMetrics(tableName, true);
            long tasksCompletedAfterRead = executor.getCompletedTaskCount();
            Assert.assertEquals((long)2L, (long)(tasksCompletedAfterRead - tasksCompletedBeforeRead));
            KeyValue keyValue = new KeyValue(ROW2, CF, CQ, Long.MIN_VALUE, VALUE);
            this.assertBytesReadFromFs(tableName, scanMetrics.bytesReadFromFs.get(), keyValue, scanMetrics.blockReadOpsCount.get());
            Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromBlockCache.get());
            Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromMemstore.get());
        }
        finally {
            this.UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBytesReadFromBlockCache() throws Exception {
        this.UTIL.startMiniCluster();
        try {
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            this.createTable(tableName, true, BloomType.NONE);
            HRegionServer server = this.UTIL.getMiniHBaseCluster().getRegionServer(0);
            LruBlockCache blockCache = (LruBlockCache)server.getBlockCache().get();
            Assert.assertTrue((blockCache.acceptableSize() > 0x100000L ? 1 : 0) != 0);
            this.writeData(tableName, true);
            this.readDataAndGetScanMetrics(tableName, false);
            KeyValue keyValue = new KeyValue(ROW2, CF, CQ, Long.MIN_VALUE, VALUE);
            this.assertBlockCacheWarmUp(tableName, keyValue);
            ScanMetrics scanMetrics = this.readDataAndGetScanMetrics(tableName, true);
            Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromFs.get());
            this.assertBytesReadFromBlockCache(tableName, scanMetrics.bytesReadFromBlockCache.get(), keyValue);
            Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromMemstore.get());
        }
        finally {
            this.UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBytesReadFromMemstore() throws Exception {
        this.UTIL.startMiniCluster();
        try {
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            this.createTable(tableName, false, BloomType.NONE);
            this.writeData(tableName, false);
            ScanMetrics scanMetrics = this.readDataAndGetScanMetrics(tableName, true);
            List<HRegion> regions = this.UTIL.getMiniHBaseCluster().getRegions(tableName);
            for (HRegion region : regions) {
                HStore store = region.getStore(CF);
                Assert.assertEquals((long)0L, (long)store.getStorefiles().size());
            }
            KeyValue keyValue = new KeyValue(ROW2, CF, CQ, Long.MAX_VALUE, VALUE);
            int singleKeyValueSize = Segment.getCellLength((Cell)keyValue);
            int totalKeyValueSize = 2 * singleKeyValueSize;
            Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromFs.get());
            Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromBlockCache.get());
            Assert.assertEquals((long)totalKeyValueSize, (long)scanMetrics.bytesReadFromMemstore.get());
        }
        finally {
            this.UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBytesReadWithSwitchFromPReadToStream() throws Exception {
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("hbase.storescanner.pread.max.bytes", "3");
        this.UTIL.startMiniCluster();
        try {
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            this.createTable(tableName, true, BloomType.ROW, configuration);
            this.writeData(tableName, true);
            Scan scan = new Scan();
            scan.withStartRow(ROW2, true);
            scan.withStopRow(ROW4, true);
            scan.setScanMetricsEnabled(true);
            scan.setCaching(1);
            ScanMetrics scanMetrics = null;
            StoreScanner.instrument();
            try (Table table = this.UTIL.getConnection().getTable(tableName);
                 ResultScanner scanner = table.getScanner(scan);){
                int rowCount = 0;
                Assert.assertFalse((boolean)StoreScanner.hasSwitchedToStreamRead());
                for (Result r : scanner) {
                    ++rowCount;
                }
                Assert.assertTrue((boolean)StoreScanner.hasSwitchedToStreamRead());
                Assert.assertEquals((long)2L, (long)rowCount);
                scanMetrics = scanner.getScanMetrics();
            }
            int bytesReadFromFs = this.getBytesReadFromFsForNonGetScan(tableName, scanMetrics, 2);
            Assert.assertEquals((long)bytesReadFromFs, (long)scanMetrics.bytesReadFromFs.get());
            Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromBlockCache.get());
            Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromMemstore.get());
            Assert.assertEquals((long)2L, (long)scanMetrics.blockReadOpsCount.get());
            Assert.assertEquals((long)2L, (long)scanMetrics.countOfRPCcalls.get());
        }
        finally {
            this.UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBytesReadWhenFlushHappenedInTheMiddleOfScan() throws Exception {
        this.UTIL.startMiniCluster();
        try {
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            this.createTable(tableName, true, BloomType.ROW);
            this.writeData(tableName, false);
            Scan scan = new Scan();
            scan.withStartRow(ROW2, true);
            scan.withStopRow(ROW4, true);
            scan.setScanMetricsEnabled(true);
            scan.setCaching(1);
            ScanMetrics scanMetrics = null;
            try (Table table = this.UTIL.getConnection().getTable(tableName);
                 ResultScanner scanner = table.getScanner(scan);){
                int rowCount = 0;
                for (Result r : scanner) {
                    if (++rowCount != 1) continue;
                    this.flushAndWaitUntilFlushed(tableName, true);
                }
                Assert.assertEquals((long)2L, (long)rowCount);
                scanMetrics = scanner.getScanMetrics();
            }
            int bytesReadFromFs = this.getBytesReadFromFsForNonGetScan(tableName, scanMetrics, 1);
            Assert.assertEquals((long)bytesReadFromFs, (long)scanMetrics.bytesReadFromFs.get());
            Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromBlockCache.get());
            int bytesReadFromMemstore = Segment.getCellLength((Cell)new KeyValue(ROW2, CF, CQ, Long.MAX_VALUE, VALUE));
            Assert.assertEquals((long)(2 * bytesReadFromMemstore), (long)scanMetrics.bytesReadFromMemstore.get());
            Assert.assertEquals((long)1L, (long)scanMetrics.blockReadOpsCount.get());
            Assert.assertEquals((long)2L, (long)scanMetrics.countOfRPCcalls.get());
        }
        finally {
            this.UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBytesReadInReverseScan() throws Exception {
        this.UTIL.startMiniCluster();
        try {
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            this.createTable(tableName, true, BloomType.ROW);
            this.writeData(tableName, true);
            Scan scan = new Scan();
            scan.withStartRow(ROW4, true);
            scan.withStopRow(ROW2, true);
            scan.setScanMetricsEnabled(true);
            scan.setReversed(true);
            scan.setCaching(1);
            ScanMetrics scanMetrics = null;
            try (Table table = this.UTIL.getConnection().getTable(tableName);
                 ResultScanner scanner = table.getScanner(scan);){
                int rowCount = 0;
                for (Result r : scanner) {
                    ++rowCount;
                }
                Assert.assertEquals((long)2L, (long)rowCount);
                scanMetrics = scanner.getScanMetrics();
                System.out.println("Scan metrics: " + scanMetrics.toString());
            }
            int bytesReadFromFs = this.getBytesReadFromFsForNonGetScan(tableName, scanMetrics, 2);
            Assert.assertEquals((long)bytesReadFromFs, (long)scanMetrics.bytesReadFromFs.get());
            Assert.assertEquals((long)(bytesReadFromFs / 2), (long)scanMetrics.bytesReadFromBlockCache.get());
            Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromMemstore.get());
            Assert.assertEquals((long)2L, (long)scanMetrics.blockReadOpsCount.get());
            Assert.assertEquals((long)2L, (long)scanMetrics.countOfRPCcalls.get());
        }
        finally {
            this.UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBytesReadWithLazySeek() throws Exception {
        this.UTIL.startMiniCluster();
        try {
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            this.createTable(tableName, true, BloomType.NONE);
            this.writeData(tableName, true);
            try (Table table = this.UTIL.getConnection().getTable(tableName);){
                byte[] newValue = Bytes.toBytes((String)"new value");
                table.put(new Put(ROW2).addColumn(CF, CQ, newValue));
                Scan scan = new Scan();
                scan.withStartRow(ROW2, true);
                scan.withStopRow(ROW2, true);
                scan.setScanMetricsEnabled(true);
                HashMap familyMap = new HashMap();
                familyMap.put(CF, new TreeSet(Bytes.BYTES_COMPARATOR));
                ((NavigableSet)familyMap.get(CF)).add(CQ);
                scan.setFamilyMap(familyMap);
                ScanMetrics scanMetrics = null;
                try (ResultScanner scanner = table.getScanner(scan);){
                    int rowCount = 0;
                    for (Result r : scanner) {
                        ++rowCount;
                        Assert.assertArrayEquals((byte[])newValue, (byte[])r.getValue(CF, CQ));
                    }
                    Assert.assertEquals((long)1L, (long)rowCount);
                    scanMetrics = scanner.getScanMetrics();
                }
                Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromFs.get());
                Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromBlockCache.get());
                Assert.assertEquals((long)0L, (long)scanMetrics.blockReadOpsCount.get());
                int cellSize = Segment.getCellLength((Cell)new KeyValue(ROW2, CF, CQ, Long.MAX_VALUE, newValue));
                Assert.assertEquals((long)cellSize, (long)scanMetrics.bytesReadFromMemstore.get());
                Assert.assertEquals((long)1L, (long)scanMetrics.countOfRPCcalls.get());
            }
        }
        finally {
            this.UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsecutiveRegionScannerNextCalls() throws Exception {
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("hbase.storescanner.pread.max.bytes", Integer.toString(65536));
        this.UTIL.startMiniCluster();
        try {
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            this.createTable(tableName, true, BloomType.NONE, 4, configuration);
            try (Table table = this.UTIL.getConnection().getTable(tableName);){
                table.put(new Put(ROW2).addColumn(CF, CQ, VALUE));
                table.put(new Put(ROW3).addColumn(CF, CQ, VALUE));
                table.put(new Put(ROW4).addColumn(CF, CQ, VALUE));
                ScanMetrics scanMetrics = null;
                Scan scan = this.createScanToReadOneRowAtATimeFromServer(ROW2, ROW3);
                try (ResultScanner scanner = table.getScanner(scan);){
                    int rowCount = 0;
                    for (Object r : scanner) {
                        ++rowCount;
                    }
                    Assert.assertEquals((long)2L, (long)rowCount);
                    scanMetrics = scanner.getScanMetrics();
                }
                int cellSize = Segment.getCellLength((Cell)new KeyValue(ROW2, CF, CQ, Long.MAX_VALUE, VALUE));
                Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromFs.get());
                Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromBlockCache.get());
                Assert.assertEquals((long)0L, (long)scanMetrics.blockReadOpsCount.get());
                Assert.assertEquals((long)2L, (long)scanMetrics.countOfRPCcalls.get());
                Assert.assertEquals((long)(3 * cellSize), (long)scanMetrics.bytesReadFromMemstore.get());
                this.flushAndWaitUntilFlushed(tableName, false);
                scan = this.createScanToReadOneRowAtATimeFromServer(ROW2, ROW3);
                scanMetrics = null;
                try (ResultScanner scanner = table.getScanner(scan);){
                    int rowCount = 0;
                    for (Result r : scanner) {
                        ++rowCount;
                    }
                    Assert.assertEquals((long)2L, (long)rowCount);
                    scanMetrics = scanner.getScanMetrics();
                }
                int bytesReadFromFs = this.getBytesReadToReadConsecutiveDataBlocks(tableName, 1, 3, true);
                Assert.assertEquals((long)bytesReadFromFs, (long)scanMetrics.bytesReadFromFs.get());
                Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromBlockCache.get());
                Assert.assertEquals((long)3L, (long)scanMetrics.blockReadOpsCount.get());
                Assert.assertEquals((long)2L, (long)scanMetrics.countOfRPCcalls.get());
                Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromMemstore.get());
                scan = this.createScanToReadOneRowAtATimeFromServer(ROW2, ROW3);
                scanMetrics = null;
                try (ResultScanner scanner = table.getScanner(scan);){
                    int rowCount = 0;
                    for (Result r : scanner) {
                        ++rowCount;
                    }
                    Assert.assertEquals((long)2L, (long)rowCount);
                    scanMetrics = scanner.getScanMetrics();
                }
                int bytesReadFromBlockCache = this.getBytesReadToReadConsecutiveDataBlocks(tableName, 1, 3, false);
                Assert.assertEquals((long)bytesReadFromBlockCache, (long)scanMetrics.bytesReadFromBlockCache.get());
                Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromFs.get());
                Assert.assertEquals((long)0L, (long)scanMetrics.blockReadOpsCount.get());
                Assert.assertEquals((long)2L, (long)scanMetrics.countOfRPCcalls.get());
                Assert.assertEquals((long)0L, (long)scanMetrics.bytesReadFromMemstore.get());
            }
        }
        finally {
            this.UTIL.shutdownMiniCluster();
        }
    }

    private Scan createScanToReadOneRowAtATimeFromServer(byte[] startRow, byte[] stopRow) {
        Scan scan = new Scan();
        scan.withStartRow(startRow, true);
        scan.withStopRow(stopRow, true);
        scan.setScanMetricsEnabled(true);
        scan.setCaching(1);
        return scan;
    }

    private void flushAndWaitUntilFlushed(TableName tableName, boolean waitForUpdatedReaders) throws Exception {
        if (waitForUpdatedReaders) {
            StoreScanner.instrument();
        }
        this.UTIL.flush(tableName);
        List<HRegion> regions = this.UTIL.getMiniHBaseCluster().getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        HRegion region = regions.get(0);
        HStore store = region.getStore(CF);
        int maxWaitTime = 100000;
        int totalWaitTime = 0;
        int sleepTime = 10000;
        while (store.getStorefiles().size() == 0 || waitForUpdatedReaders && !StoreScanner.hasUpdatedReaders()) {
            Thread.sleep(sleepTime);
            if ((totalWaitTime += sleepTime) < maxWaitTime) continue;
            throw new Exception("Store files not flushed after " + maxWaitTime + "ms");
        }
        Assert.assertEquals((long)1L, (long)store.getStorefiles().size());
    }

    private int getBytesReadToReadConsecutiveDataBlocks(TableName tableName, int expectedStoreFileCount, int expectedDataBlockCount, boolean isReadFromFs) throws Exception {
        List<HRegion> regions = this.UTIL.getMiniHBaseCluster().getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        HRegion region = regions.get(0);
        HStore store = region.getStore(CF);
        Collection storeFiles = store.getStorefiles();
        Assert.assertEquals((long)expectedStoreFileCount, (long)storeFiles.size());
        int bytesReadFromFs = 0;
        for (HStoreFile storeFile : storeFiles) {
            HFileBlock block;
            StoreFileReader reader = storeFile.getReader();
            HFile.Reader hfileReader = reader.getHFileReader();
            HFileBlock.FSReader blockReader = hfileReader.getUncachedBlockReader();
            FixedFileTrailer trailer = hfileReader.getTrailer();
            int dataIndexLevels = trailer.getNumDataIndexLevels();
            long loadOnOpenDataOffset = trailer.getLoadOnOpenDataOffset();
            HFileBlock.BlockIterator blockIterator = blockReader.blockRange(0L, loadOnOpenDataOffset);
            boolean readNextBlock = false;
            int blockCount = 0;
            while ((block = blockIterator.nextBlock()) != null) {
                ++blockCount;
                bytesReadFromFs += block.getOnDiskSizeWithHeader();
                if (isReadFromFs && readNextBlock) {
                    bytesReadFromFs -= block.headerSize();
                    readNextBlock = false;
                }
                if (block.getNextBlockOnDiskSize() > 0) {
                    bytesReadFromFs += block.headerSize();
                    readNextBlock = true;
                }
                Assert.assertTrue((boolean)block.getBlockType().isData());
            }
            blockIterator.freeBlocks();
            Assert.assertEquals((long)1L, (long)dataIndexLevels);
            Assert.assertEquals((long)expectedDataBlockCount, (long)blockCount);
        }
        return bytesReadFromFs;
    }

    private int getBytesReadFromFsForNonGetScan(TableName tableName, ScanMetrics scanMetrics, int expectedStoreFileCount) throws Exception {
        List<HRegion> regions = this.UTIL.getMiniHBaseCluster().getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        HRegion region = regions.get(0);
        HStore store = region.getStore(CF);
        Collection storeFiles = store.getStorefiles();
        Assert.assertEquals((long)expectedStoreFileCount, (long)storeFiles.size());
        int bytesReadFromFs = 0;
        for (HStoreFile storeFile : storeFiles) {
            StoreFileReader reader = storeFile.getReader();
            HFile.Reader hfileReader = reader.getHFileReader();
            HFileBlock.FSReader blockReader = hfileReader.getUncachedBlockReader();
            FixedFileTrailer trailer = hfileReader.getTrailer();
            int dataIndexLevels = trailer.getNumDataIndexLevels();
            HFileBlock block = blockReader.readBlockData(0L, -1L, true, true, true);
            Assert.assertTrue((boolean)block.getBlockType().isData());
            bytesReadFromFs += block.getOnDiskSizeWithHeader();
            if (block.getNextBlockOnDiskSize() > 0) {
                bytesReadFromFs += block.headerSize();
            }
            block.release();
            Assert.assertEquals((long)1L, (long)dataIndexLevels);
        }
        return bytesReadFromFs;
    }

    private ScanMetrics readDataAndGetScanMetrics(TableName tableName, boolean isScanMetricsEnabled) throws Exception {
        ScanMetrics scanMetrics;
        Scan scan = new Scan();
        scan.withStartRow(ROW2, true);
        scan.withStopRow(ROW2, true);
        scan.setScanMetricsEnabled(isScanMetricsEnabled);
        try (Table table = this.UTIL.getConnection().getTable(tableName);
             ResultScanner scanner = table.getScanner(scan);){
            int rowCount = 0;
            StoreFileScanner.instrument();
            for (Result r : scanner) {
                ++rowCount;
            }
            Assert.assertEquals((long)1L, (long)rowCount);
            scanMetrics = scanner.getScanMetrics();
        }
        if (isScanMetricsEnabled) {
            LOG.info("Bytes read from fs: " + scanMetrics.bytesReadFromFs.get());
            LOG.info("Bytes read from block cache: " + scanMetrics.bytesReadFromBlockCache.get());
            LOG.info("Bytes read from memstore: " + scanMetrics.bytesReadFromMemstore.get());
            LOG.info("StoreFileScanners seek count: " + StoreFileScanner.getSeekCount());
        }
        return scanMetrics;
    }

    private void writeData(TableName tableName, boolean shouldFlush) throws Exception {
        try (Table table = this.UTIL.getConnection().getTable(tableName);){
            table.put(new Put(ROW2).addColumn(CF, CQ, VALUE));
            table.put(new Put(ROW4).addColumn(CF, CQ, VALUE));
            if (shouldFlush) {
                this.UTIL.flush(tableName);
            }
            table.put(new Put(Bytes.toBytes((String)"row1")).addColumn(CF, CQ, VALUE));
            table.put(new Put(Bytes.toBytes((String)"row5")).addColumn(CF, CQ, VALUE));
            if (shouldFlush) {
                this.UTIL.flush(tableName);
            }
        }
    }

    private void createTable(TableName tableName, boolean blockCacheEnabled, BloomType bloomType) throws Exception {
        this.createTable(tableName, blockCacheEnabled, bloomType, 65536, new HashMap<String, String>());
    }

    private void createTable(TableName tableName, boolean blockCacheEnabled, BloomType bloomType, Map<String, String> configuration) throws Exception {
        this.createTable(tableName, blockCacheEnabled, bloomType, 65536, configuration);
    }

    private void createTable(TableName tableName, boolean blockCacheEnabled, BloomType bloomType, int blocksize, Map<String, String> configuration) throws Exception {
        Admin admin = this.UTIL.getAdmin();
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        ColumnFamilyDescriptorBuilder columnFamilyDescriptorBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF);
        columnFamilyDescriptorBuilder.setBloomFilterType(bloomType);
        columnFamilyDescriptorBuilder.setBlockCacheEnabled(blockCacheEnabled);
        columnFamilyDescriptorBuilder.setBlocksize(blocksize);
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            columnFamilyDescriptorBuilder.setConfiguration(entry.getKey(), entry.getValue());
        }
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptorBuilder.build());
        admin.createTable(tableDescriptorBuilder.build());
        this.UTIL.waitUntilAllRegionsAssigned(tableName);
    }

    private void assertBytesReadFromFs(TableName tableName, long actualBytesReadFromFs, KeyValue keyValue, long actualReadOps) throws Exception {
        List<HRegion> regions = this.UTIL.getMiniHBaseCluster().getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        final MutableInt totalExpectedBytesReadFromFs = new MutableInt(0);
        final MutableInt totalExpectedReadOps = new MutableInt(0);
        for (HRegion region : regions) {
            Assert.assertNull((Object)region.getBlockCache());
            HStore store = region.getStore(CF);
            Collection storeFiles = store.getStorefiles();
            Assert.assertEquals((long)2L, (long)storeFiles.size());
            for (HStoreFile storeFile : storeFiles) {
                StoreFileReader reader = storeFile.getReader();
                HFile.Reader hfileReader = reader.getHFileReader();
                BloomFilter bloomFilter = reader.getGeneralBloomFilter();
                Assert.assertTrue((bloomFilter == null || bloomFilter instanceof CompoundBloomFilter ? 1 : 0) != 0);
                CompoundBloomFilter cbf = bloomFilter == null ? null : (CompoundBloomFilter)bloomFilter;
                Consumer<HFileBlock> bytesReadFunction = new Consumer<HFileBlock>(){

                    @Override
                    public void accept(HFileBlock block) {
                        totalExpectedBytesReadFromFs.add(block.getOnDiskSizeWithHeader());
                        if (block.getNextBlockOnDiskSize() > 0) {
                            totalExpectedBytesReadFromFs.add(block.headerSize());
                        }
                        totalExpectedReadOps.add(1);
                    }
                };
                this.readHFile(hfileReader, cbf, keyValue, bytesReadFunction);
            }
        }
        Assert.assertEquals((long)totalExpectedBytesReadFromFs.longValue(), (long)actualBytesReadFromFs);
        Assert.assertEquals((long)totalExpectedReadOps.longValue(), (long)actualReadOps);
    }

    private void readHFile(HFile.Reader hfileReader, CompoundBloomFilter cbf, KeyValue keyValue, Consumer<HFileBlock> bytesReadFunction) throws Exception {
        HFileBlock.FSReader blockReader = hfileReader.getUncachedBlockReader();
        FixedFileTrailer trailer = hfileReader.getTrailer();
        HFileContext meta = hfileReader.getFileContext();
        long fileSize = hfileReader.length();
        if (cbf != null) {
            blockReader.readBlockData(trailer.getLoadOnOpenDataOffset(), -1L, true, true, true).release();
            HFileBlockIndex.BlockIndexReader index = cbf.getBloomIndex();
            byte[] row = ROW2;
            int blockIndex = index.rootBlockContainingKey(row, 0, row.length);
            HFileBlock bloomBlock = cbf.getBloomBlock(blockIndex);
            boolean fileContainsKey = BloomFilterUtil.contains((byte[])row, (int)0, (int)row.length, (ByteBuff)bloomBlock.getBufferReadOnly(), (int)bloomBlock.headerSize(), (int)bloomBlock.getUncompressedSizeWithoutHeader(), (Hash)cbf.getHash(), (int)cbf.getHashCount());
            bytesReadFunction.accept(bloomBlock);
            Assert.assertEquals((Object)bloomBlock.getBlockType(), (Object)BlockType.BLOOM_CHUNK);
            bloomBlock.release();
            if (!fileContainsKey) {
                return;
            }
        }
        MyNoOpEncodedSeeker seeker = new MyNoOpEncodedSeeker();
        HFileBlock.BlockIterator blockIter = blockReader.blockRange(trailer.getLoadOnOpenDataOffset(), fileSize - (long)trailer.getTrailerSize());
        HFileBlock block = blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX);
        CellComparator comparator = trailer.createComparator();
        seeker.initRootIndex(block, trailer.getDataIndexCount(), comparator, trailer.getNumDataIndexLevels());
        int blockLevelsRead = 1;
        int rootLevIndex = seeker.rootBlockContainingKey((Cell)keyValue);
        long currentOffset = seeker.getBlockOffset(rootLevIndex);
        int currentDataSize = seeker.getBlockDataSize(rootLevIndex);
        HFileBlock prevBlock = null;
        do {
            prevBlock = block;
            block = blockReader.readBlockData(currentOffset, (long)currentDataSize, true, true, true);
            HFileBlock unpacked = block.unpack(meta, blockReader);
            if (unpacked != block) {
                block.release();
                block = unpacked;
            }
            bytesReadFunction.accept(block);
            if (!block.getBlockType().isData()) {
                ByteBuff buffer = block.getBufferWithoutHeader();
                HFileBlockIndex.BlockIndexReader.locateNonRootIndexEntry((ByteBuff)buffer, (Cell)keyValue, (CellComparator)comparator);
                currentOffset = buffer.getLong();
                currentDataSize = buffer.getInt();
            }
            prevBlock.release();
            ++blockLevelsRead;
        } while (!block.getBlockType().isData());
        block.release();
        blockIter.freeBlocks();
        Assert.assertEquals((long)blockLevelsRead, (long)(trailer.getNumDataIndexLevels() + 1));
    }

    private void assertBytesReadFromBlockCache(TableName tableName, long actualBytesReadFromBlockCache, KeyValue keyValue) throws Exception {
        List<HRegion> regions = this.UTIL.getMiniHBaseCluster().getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        final MutableInt totalExpectedBytesReadFromBlockCache = new MutableInt(0);
        for (HRegion region : regions) {
            Assert.assertNotNull((Object)region.getBlockCache());
            HStore store = region.getStore(CF);
            Collection storeFiles = store.getStorefiles();
            Assert.assertEquals((long)2L, (long)storeFiles.size());
            for (HStoreFile storeFile : storeFiles) {
                StoreFileReader reader = storeFile.getReader();
                HFile.Reader hfileReader = reader.getHFileReader();
                BloomFilter bloomFilter = reader.getGeneralBloomFilter();
                Assert.assertTrue((bloomFilter == null || bloomFilter instanceof CompoundBloomFilter ? 1 : 0) != 0);
                CompoundBloomFilter cbf = bloomFilter == null ? null : (CompoundBloomFilter)bloomFilter;
                Consumer<HFileBlock> bytesReadFunction = new Consumer<HFileBlock>(){

                    @Override
                    public void accept(HFileBlock block) {
                        totalExpectedBytesReadFromBlockCache.add(block.getOnDiskSizeWithHeader());
                        if (block.getNextBlockOnDiskSize() > 0) {
                            totalExpectedBytesReadFromBlockCache.add(block.headerSize());
                        }
                    }
                };
                this.readHFile(hfileReader, cbf, keyValue, bytesReadFunction);
            }
        }
        Assert.assertEquals((long)totalExpectedBytesReadFromBlockCache.longValue(), (long)actualBytesReadFromBlockCache);
    }

    private void assertBlockCacheWarmUp(TableName tableName, KeyValue keyValue) throws Exception {
        List<HRegion> regions = this.UTIL.getMiniHBaseCluster().getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        for (final HRegion region : regions) {
            Assert.assertNotNull((Object)region.getBlockCache());
            HStore store = region.getStore(CF);
            Collection storeFiles = store.getStorefiles();
            Assert.assertEquals((long)2L, (long)storeFiles.size());
            for (HStoreFile storeFile : storeFiles) {
                StoreFileReader reader = storeFile.getReader();
                final HFile.Reader hfileReader = reader.getHFileReader();
                BloomFilter bloomFilter = reader.getGeneralBloomFilter();
                Assert.assertTrue((bloomFilter == null || bloomFilter instanceof CompoundBloomFilter ? 1 : 0) != 0);
                CompoundBloomFilter cbf = bloomFilter == null ? null : (CompoundBloomFilter)bloomFilter;
                Consumer<HFileBlock> bytesReadFunction = new Consumer<HFileBlock>(){

                    @Override
                    public void accept(HFileBlock block) {
                        TestBytesReadServerSideScanMetrics.this.assertBlockIsCached(hfileReader, block, region.getBlockCache());
                    }
                };
                this.readHFile(hfileReader, cbf, keyValue, bytesReadFunction);
            }
        }
    }

    private void assertBlockIsCached(HFile.Reader hfileReader, HFileBlock block, BlockCache blockCache) {
        if (blockCache == null) {
            return;
        }
        Path path = hfileReader.getPath();
        BlockCacheKey key = new BlockCacheKey(path.getName(), block.getOffset(), true, block.getBlockType());
        HFileBlock cachedBlock = (HFileBlock)blockCache.getBlock(key, true, false, true);
        Assert.assertNotNull((Object)cachedBlock);
        Assert.assertEquals((long)block.getOnDiskSizeWithHeader(), (long)cachedBlock.getOnDiskSizeWithHeader());
        Assert.assertEquals((long)block.getNextBlockOnDiskSize(), (long)cachedBlock.getNextBlockOnDiskSize());
        cachedBlock.release();
    }

    private static class MyNoOpEncodedSeeker
    extends NoOpIndexBlockEncoder.NoOpEncodedSeeker {
        private MyNoOpEncodedSeeker() {
        }

        public long getBlockOffset(int i) {
            return this.blockOffsets[i];
        }

        public int getBlockDataSize(int i) {
            return this.blockDataSizes[i];
        }
    }
}

