/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncBufferedMutator;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PluggableBlockingQueue;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.SimpleRpcScheduler;
import org.apache.hadoop.hbase.ipc.TestPluggableQueueImpl;
import org.apache.hadoop.hbase.regionserver.RpcSchedulerFactory;
import org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncClientPauseForServerOverloaded {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncClientPauseForServerOverloaded.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"ServerOverloaded");
    private static byte[] FAMILY = Bytes.toBytes((String)"Family");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"Qualifier");
    private static long PAUSE_FOR_SERVER_OVERLOADED_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private static long PAUSE_FOR_SERVER_OVERLOADED_MILLIS = TimeUnit.NANOSECONDS.toMillis(PAUSE_FOR_SERVER_OVERLOADED_NANOS);
    private static AsyncConnection CONN;
    private static volatile FailMode MODE;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setLong("hbase.client.pause", 10L);
        UTIL.getConfiguration().set("hbase.ipc.server.callqueue.type", "pluggable");
        UTIL.getConfiguration().setClass("hbase.ipc.server.callqueue.pluggable.queue.class.name", OverloadedQueue.class, PluggableBlockingQueue.class);
        UTIL.getConfiguration().setClass("hbase.region.server.rpc.scheduler.factory.class", OverloadedRpcSchedulerFactory.class, RpcSchedulerFactory.class);
        UTIL.startMiniCluster(1);
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setLong("hbase.client.pause.server.overloaded", PAUSE_FOR_SERVER_OVERLOADED_MILLIS);
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)conf).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUpBeforeTest() throws IOException {
        try (Table table = UTIL.createTable(TABLE_NAME, FAMILY);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)i)));
            }
        }
        MODE = FailMode.CALL_QUEUE_TOO_BIG;
    }

    @After
    public void tearDownAfterTest() throws IOException {
        for (FailMode mode : FailMode.values()) {
            mode.invoked.clear();
        }
        MODE = null;
        UTIL.getAdmin().disableTable(TABLE_NAME);
        UTIL.getAdmin().deleteTable(TABLE_NAME);
    }

    private void assertTime(Callable<Void> callable, long time) throws Exception {
        FailMode[] failModeArray = FailMode.values();
        int n = failModeArray.length;
        for (int i = 0; i < n; ++i) {
            FailMode mode;
            MODE = mode = failModeArray[i];
            long startNs = System.nanoTime();
            callable.call();
            long costNs = System.nanoTime() - startNs;
            Assert.assertTrue((costNs > time ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGet() throws Exception {
        this.assertTime(() -> {
            Result result = (Result)CONN.getTable(TABLE_NAME).get(new Get(Bytes.toBytes((int)0))).get();
            Assert.assertArrayEquals((byte[])Bytes.toBytes((int)0), (byte[])result.getValue(FAMILY, QUALIFIER));
            return null;
        }, PAUSE_FOR_SERVER_OVERLOADED_NANOS);
    }

    @Test
    public void testBatch() throws Exception {
        this.assertTime(() -> {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            try (AsyncBufferedMutator mutator = CONN.getBufferedMutator(TABLE_NAME);){
                for (int i = 100; i < 110; ++i) {
                    futures.add(mutator.mutate((Mutation)new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)i))));
                }
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
        }, PAUSE_FOR_SERVER_OVERLOADED_NANOS);
    }

    @Test
    public void testScan() throws Exception {
        this.assertTime(() -> {
            try (ResultScanner scanner = CONN.getTable(TABLE_NAME).getScanner(new Scan().setCaching(80));){
                for (int i = 0; i < 100; ++i) {
                    Result result = scanner.next();
                    Assert.assertArrayEquals((byte[])Bytes.toBytes((int)i), (byte[])result.getValue(FAMILY, QUALIFIER));
                }
                Assert.assertNull((Object)scanner.next());
            }
            return null;
        }, PAUSE_FOR_SERVER_OVERLOADED_NANOS * 2L);
    }

    static {
        MODE = null;
    }

    public static final class OverloadedRpcSchedulerFactory
    extends SimpleRpcSchedulerFactory {
        public RpcScheduler create(Configuration conf, PriorityFunction priority, Abortable server) {
            int handlerCount = conf.getInt("hbase.regionserver.handler.count", 30);
            return new OverloadedRpcScheduler(conf, handlerCount, conf.getInt("hbase.regionserver.metahandler.count", 20), conf.getInt("hbase.regionserver.replication.handler.count", 3), conf.getInt("hbase.master.meta.transition.handler.count", 1), priority, server, 10);
        }
    }

    public static final class OverloadedQueue
    extends TestPluggableQueueImpl {
        public OverloadedQueue(int maxQueueLength, PriorityFunction priority, Configuration conf) {
            super(maxQueueLength, priority, conf);
        }

        @Override
        public boolean offer(CallRunner callRunner) {
            if (MODE == FailMode.CALL_DROPPED && MODE.shouldFail(callRunner)) {
                callRunner.drop();
                return true;
            }
            return super.offer(callRunner);
        }
    }

    public static final class OverloadedRpcScheduler
    extends SimpleRpcScheduler {
        public OverloadedRpcScheduler(Configuration conf, int handlerCount, int priorityHandlerCount, int replicationHandlerCount, int metaTransitionHandler, PriorityFunction priority, Abortable server, int highPriorityLevel) {
            super(conf, handlerCount, priorityHandlerCount, replicationHandlerCount, metaTransitionHandler, priority, server, highPriorityLevel);
        }

        public boolean dispatch(CallRunner callTask) {
            if (MODE == FailMode.CALL_QUEUE_TOO_BIG && MODE.shouldFail(callTask)) {
                return false;
            }
            return super.dispatch(callTask);
        }
    }

    static enum FailMode {
        CALL_QUEUE_TOO_BIG,
        CALL_DROPPED;

        private ConcurrentMap<Descriptors.MethodDescriptor, AtomicInteger> invoked = new ConcurrentHashMap<Descriptors.MethodDescriptor, AtomicInteger>();

        private boolean shouldFail(CallRunner callRunner) {
            Descriptors.MethodDescriptor method = callRunner.getRpcCall().getMethod();
            return this.invoked.computeIfAbsent(method, k -> new AtomicInteger(0)).getAndIncrement() % 2 == 0;
        }
    }
}

