/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.bulkdatagenerator;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.bulkdatagenerator.Utility;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;

public class BulkDataGeneratorMapper
extends Mapper<Text, NullWritable, ImmutableBytesWritable, KeyValue> {
    public static final String SPLIT_COUNT_KEY = BulkDataGeneratorMapper.class.getName() + "split.count";
    private static final String ORG_ID = "00D000000000062";
    private static final int MAX_EVENT_ID = Integer.MAX_VALUE;
    private static final int MAX_VEHICLE_ID = 100;
    private static final int MAX_SPEED_KPH = 140;
    private static final int NUM_LOCATIONS = 10;
    private static int splitCount = 1;
    private static final Random random = new Random(System.currentTimeMillis());
    private static final Map<String, Pair<BigDecimal, BigDecimal>> LOCATIONS = Maps.newHashMapWithExpectedSize((int)10);
    private static final List<String> LOCATION_KEYS = Lists.newArrayListWithCapacity((int)10);
    static final byte[] COLUMN_FAMILY_BYTES;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration c = context.getConfiguration();
        splitCount = c.getInt(SPLIT_COUNT_KEY, 1);
    }

    protected void map(Text key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
        int recordIndex = Integer.parseInt(key.toString());
        String toolEventId = String.format("%06d", recordIndex % (splitCount + 1)) + "_" + EnvironmentEdgeManager.currentTime() + (1.0E14 + (double)random.nextFloat() * 9.0E13) + "_" + recordIndex;
        String eventId = String.valueOf(Math.abs(random.nextInt(Integer.MAX_VALUE)));
        String vechileId = String.valueOf(Math.abs(random.nextInt(100)));
        String speed = String.valueOf(Math.abs(random.nextInt(140)));
        String location = LOCATION_KEYS.get(random.nextInt(10));
        Pair<BigDecimal, BigDecimal> coordinates = LOCATIONS.get(location);
        BigDecimal latitude = (BigDecimal)coordinates.getFirst();
        BigDecimal longitude = (BigDecimal)coordinates.getSecond();
        ImmutableBytesWritable hKey = new ImmutableBytesWritable(String.format("%s:%s", toolEventId, ORG_ID).getBytes());
        this.addKeyValue(context, hKey, Utility.TableColumnNames.ORG_ID, ORG_ID);
        this.addKeyValue(context, hKey, Utility.TableColumnNames.TOOL_EVENT_ID, toolEventId);
        this.addKeyValue(context, hKey, Utility.TableColumnNames.EVENT_ID, eventId);
        this.addKeyValue(context, hKey, Utility.TableColumnNames.VEHICLE_ID, vechileId);
        this.addKeyValue(context, hKey, Utility.TableColumnNames.SPEED, speed);
        this.addKeyValue(context, hKey, Utility.TableColumnNames.LATITUDE, latitude.toString());
        this.addKeyValue(context, hKey, Utility.TableColumnNames.LONGITUDE, longitude.toString());
        this.addKeyValue(context, hKey, Utility.TableColumnNames.LOCATION, location);
        this.addKeyValue(context, hKey, Utility.TableColumnNames.TIMESTAMP, String.valueOf(EnvironmentEdgeManager.currentTime()));
        context.getCounter((Enum)Counters.ROWS_GENERATED).increment(1L);
    }

    private void addKeyValue(Mapper.Context context, ImmutableBytesWritable key, Utility.TableColumnNames columnName, String value) throws IOException, InterruptedException {
        KeyValue kv = new KeyValue(key.get(), COLUMN_FAMILY_BYTES, columnName.getColumnName(), value.getBytes());
        context.write((Object)key, (Object)kv);
    }

    static {
        LOCATIONS.put("Bel\u00e9m", (Pair<BigDecimal, BigDecimal>)new Pair((Object)BigDecimal.valueOf(-1.45), (Object)BigDecimal.valueOf(-48.48)));
        LOCATIONS.put("Bras\u00edlia", (Pair<BigDecimal, BigDecimal>)new Pair((Object)BigDecimal.valueOf(-15.78), (Object)BigDecimal.valueOf(-47.92)));
        LOCATIONS.put("Campinas", (Pair<BigDecimal, BigDecimal>)new Pair((Object)BigDecimal.valueOf(-22.9), (Object)BigDecimal.valueOf(-47.05)));
        LOCATIONS.put("Cuiaba", (Pair<BigDecimal, BigDecimal>)new Pair((Object)BigDecimal.valueOf(-7.25), (Object)BigDecimal.valueOf(-58.42)));
        LOCATIONS.put("Manaus", (Pair<BigDecimal, BigDecimal>)new Pair((Object)BigDecimal.valueOf(-3.1), (Object)BigDecimal.valueOf(-60.0)));
        LOCATIONS.put("Porto Velho", (Pair<BigDecimal, BigDecimal>)new Pair((Object)BigDecimal.valueOf(-8.75), (Object)BigDecimal.valueOf(-63.9)));
        LOCATIONS.put("Recife", (Pair<BigDecimal, BigDecimal>)new Pair((Object)BigDecimal.valueOf(-8.1), (Object)BigDecimal.valueOf(-34.88)));
        LOCATIONS.put("Rio de Janeiro", (Pair<BigDecimal, BigDecimal>)new Pair((Object)BigDecimal.valueOf(-22.9), (Object)BigDecimal.valueOf(-43.23)));
        LOCATIONS.put("Santar\u00e9m", (Pair<BigDecimal, BigDecimal>)new Pair((Object)BigDecimal.valueOf(-2.43), (Object)BigDecimal.valueOf(-54.68)));
        LOCATIONS.put("S\u00e3o Paulo", (Pair<BigDecimal, BigDecimal>)new Pair((Object)BigDecimal.valueOf(-23.53), (Object)BigDecimal.valueOf(-46.62)));
        LOCATION_KEYS.addAll(LOCATIONS.keySet());
        COLUMN_FAMILY_BYTES = "cf".getBytes();
    }

    public static enum Counters {
        ROWS_GENERATED;

    }
}

