/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.conf.PropagatingConfigurationObserver;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerChore;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerStateStore;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerWorkQueue;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerWorker;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionNormalizerManager
implements PropagatingConfigurationObserver {
    private static final Logger LOG = LoggerFactory.getLogger(RegionNormalizerManager.class);
    private final RegionNormalizerStateStore regionNormalizerStateStore;
    private final RegionNormalizerChore regionNormalizerChore;
    private final RegionNormalizerWorkQueue<TableName> workQueue;
    private final RegionNormalizerWorker worker;
    private final ExecutorService pool;
    private final Object startStopLock = new Object();
    private boolean started = false;
    private boolean stopped = false;

    RegionNormalizerManager(@NonNull RegionNormalizerStateStore regionNormalizerStateStore, @Nullable RegionNormalizerChore regionNormalizerChore, @Nullable RegionNormalizerWorkQueue<TableName> workQueue, @Nullable RegionNormalizerWorker worker) {
        this.regionNormalizerStateStore = regionNormalizerStateStore;
        this.regionNormalizerChore = regionNormalizerChore;
        this.workQueue = workQueue;
        this.worker = worker;
        this.pool = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("normalizer-worker-%d").setUncaughtExceptionHandler((thread, throwable) -> LOG.error("Uncaught exception, worker thread likely terminated.", throwable)).build());
    }

    public void registerChildren(ConfigurationManager manager) {
        if (this.worker != null) {
            manager.registerObserver((ConfigurationObserver)this.worker);
        }
    }

    public void deregisterChildren(ConfigurationManager manager) {
        if (this.worker != null) {
            manager.deregisterObserver((ConfigurationObserver)this.worker);
        }
    }

    public void onConfigurationChange(Configuration conf) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            if (this.worker != null) {
                this.pool.submit(this.worker);
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.started) {
                throw new IllegalStateException("calling `stop` without first calling `start`.");
            }
            if (this.stopped) {
                return;
            }
            this.pool.shutdownNow();
            this.stopped = true;
        }
    }

    public ScheduledChore getRegionNormalizerChore() {
        return this.regionNormalizerChore;
    }

    public boolean isNormalizerOn() {
        return this.regionNormalizerStateStore.get();
    }

    public void setNormalizerOn(boolean normalizerOn) throws IOException {
        this.regionNormalizerStateStore.set(normalizerOn);
    }

    public void planSkipped(NormalizationPlan.PlanType type) {
        if (this.worker != null) {
            this.worker.planSkipped(type);
        }
    }

    public long getSkippedCount(NormalizationPlan.PlanType type) {
        return this.worker == null ? 0L : this.worker.getSkippedCount(type);
    }

    public long getSplitPlanCount() {
        return this.worker == null ? 0L : this.worker.getSplitPlanCount();
    }

    public long getMergePlanCount() {
        return this.worker == null ? 0L : this.worker.getMergePlanCount();
    }

    public boolean normalizeRegions(List<TableName> tables, boolean isHighPriority) {
        if (this.workQueue == null) {
            return false;
        }
        if (isHighPriority) {
            this.workQueue.putAllFirst(tables);
        } else {
            this.workQueue.putAll(tables);
        }
        return true;
    }
}

