/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.TestFlushTableProcedureBase;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestFlushTableProcedureWithDoNotSupportFlushTableMaster
extends TestFlushTableProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFlushTableProcedureWithDoNotSupportFlushTableMaster.class);

    @Override
    protected void addConfiguration(Configuration config) {
        super.addConfiguration(config);
        config.set("hbase.master.impl", DoNotSupportFlushTableMaster.class.getName());
    }

    @Test
    public void testFlushFallback() throws IOException {
        this.assertTableMemStoreNotEmpty();
        TEST_UTIL.getAdmin().flush(this.TABLE_NAME);
        this.assertTableMemStoreEmpty();
    }

    @Test
    public void testSingleColumnFamilyFlushFallback() throws IOException {
        this.assertColumnFamilyMemStoreNotEmpty(this.FAMILY1);
        TEST_UTIL.getAdmin().flush(this.TABLE_NAME, this.FAMILY1);
        this.assertColumnFamilyMemStoreEmpty(this.FAMILY1);
    }

    @Test
    public void testMultiColumnFamilyFlushFallback() throws IOException {
        this.assertTableMemStoreNotEmpty();
        TEST_UTIL.getAdmin().flush(this.TABLE_NAME, Arrays.asList(this.FAMILY1, this.FAMILY2, this.FAMILY3));
        this.assertTableMemStoreEmpty();
    }

    public static final class DoNotSupportFlushTableMaster
    extends HMaster {
        public DoNotSupportFlushTableMaster(Configuration conf) throws IOException {
            super(conf);
        }

        public long flushTable(TableName tableName, List<byte[]> columnFamilies, long nonceGroup, long nonce) throws IOException {
            throw new DoNotRetryIOException("UnsupportedOperation: flushTable");
        }
    }
}

