/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.hadoop.util.NativeCodeLoader;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHdfsNativeCodeLoader {
    static final Logger LOG = LoggerFactory.getLogger(TestHdfsNativeCodeLoader.class);

    private static boolean requireTestJni() {
        String rtj = System.getProperty("require.test.libhadoop");
        if (rtj == null) {
            return false;
        }
        return rtj.compareToIgnoreCase("false") != 0;
    }

    @Test
    public void testNativeCodeLoaded() {
        if (!TestHdfsNativeCodeLoader.requireTestJni()) {
            LOG.info("TestNativeCodeLoader: libhadoop.so testing is not required.");
            return;
        }
        if (!NativeCodeLoader.isNativeCodeLoaded()) {
            String LD_LIBRARY_PATH = System.getenv().get("LD_LIBRARY_PATH");
            if (LD_LIBRARY_PATH == null) {
                LD_LIBRARY_PATH = "";
            }
            Assert.fail((String)("TestNativeCodeLoader: libhadoop.so testing was required, but libhadoop.so was not loaded.  LD_LIBRARY_PATH = " + LD_LIBRARY_PATH));
        }
        LOG.info("TestHdfsNativeCodeLoader: libhadoop.so is loaded.");
    }
}

