/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.filter;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.rest.RESTServer;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AuthFilter
extends AuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthFilter.class);
    private static final String REST_PREFIX = "hbase.rest.authentication.";
    private static final int REST_PREFIX_LEN = "hbase.rest.authentication.".length();

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        Properties props = super.getConfiguration(configPrefix, filterConfig);
        props.setProperty("cookie.path", "/");
        Configuration conf = null;
        conf = RESTServer.conf != null ? RESTServer.conf : HBaseConfiguration.create();
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            if (!name.startsWith(REST_PREFIX)) continue;
            String value = (String)entry.getValue();
            if (name.equals("hbase.rest.authentication.kerberos.principal")) {
                try {
                    String machineName = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("hbase.rest.dns.interface", "default"), (String)conf.get("hbase.rest.dns.nameserver", "default")));
                    value = SecurityUtil.getServerPrincipal((String)value, (String)machineName);
                }
                catch (IOException ie) {
                    throw new ServletException("Failed to retrieve server principal", (Throwable)ie);
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Setting property " + name + "=" + value);
            }
            name = name.substring(REST_PREFIX_LEN);
            props.setProperty(name, value);
        }
        return props;
    }
}

