/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.nio.ByteBuffer;
import org.apache.directory.mavibot.btree.util.Strings;

class PageIO {
    private ByteBuffer data;
    private long nextPage = -2L;
    private int size = -1;
    private long offset;

    public PageIO() {
        this.offset = -1L;
    }

    public PageIO(long offset) {
        this.offset = offset;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
        this.nextPage = data.getLong(0);
    }

    public long getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(long nextPage) {
        this.nextPage = nextPage;
        this.data.putLong(0, nextPage);
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.data.putInt(8, size);
        this.size = size;
    }

    public void setSize() {
        this.size = this.data.getInt(8);
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PageIO[offset:").append(this.offset);
        if (this.size != -1) {
            sb.append(", size:").append(this.size);
        }
        if (this.nextPage != -1L) {
            sb.append(", next:").append(this.nextPage);
        }
        sb.append("]");
        int start = 0;
        byte[] array = null;
        this.data.mark();
        this.data.position(0);
        if (this.data.isDirect()) {
            array = new byte[this.data.capacity()];
            this.data.get(array);
        } else {
            array = this.data.array();
        }
        this.data.reset();
        for (int i = start; i < array.length; ++i) {
            if ((i - start) % 16 == 0) {
                sb.append("\n    ");
            }
            sb.append(Strings.dumpByte(array[i])).append(" ");
        }
        return sb.toString();
    }
}

