/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound.impl;

import java.io.File;
import java.io.IOException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.compound.CompoundStore;
import net.sf.ehcache.store.compound.factories.DiskPersistentStorageFactory;

public final class DiskPersistentStore
extends CompoundStore
implements CacheConfigurationListener {
    private final DiskPersistentStorageFactory disk;

    private DiskPersistentStore(DiskPersistentStorageFactory disk, CacheConfiguration config) {
        super(disk, config.isCopyOnRead(), config.isCopyOnWrite(), config.getCopyStrategy());
        this.disk = disk;
    }

    public static DiskPersistentStore create(Cache cache, String diskStorePath) {
        CacheConfiguration config = cache.getCacheConfiguration();
        DiskPersistentStorageFactory disk = new DiskPersistentStorageFactory(cache, diskStorePath);
        DiskPersistentStore store = new DiskPersistentStore(disk, config);
        cache.getCacheConfiguration().addConfigurationListener(store);
        return store;
    }

    public boolean bufferFull() {
        return this.disk.bufferFull();
    }

    public boolean containsKeyInMemory(Object key) {
        return this.disk.isInMemory(this.unretrievedGet(key));
    }

    public boolean containsKeyOffHeap(Object key) {
        return false;
    }

    public boolean containsKeyOnDisk(Object key) {
        return this.disk.isOnDisk(this.unretrievedGet(key));
    }

    public void expireElements() {
        this.disk.expireElements();
    }

    public void flush() throws IOException {
        this.disk.flush();
    }

    public Policy getInMemoryEvictionPolicy() {
        return this.disk.getInMemoryEvictionPolicy();
    }

    public int getInMemorySize() {
        return this.disk.getInMemorySize();
    }

    public long getInMemorySizeInBytes() {
        return this.disk.getInMemorySizeInBytes();
    }

    public int getOffHeapSize() {
        return 0;
    }

    public long getOffHeapSizeInBytes() {
        return 0L;
    }

    public int getOnDiskSize() {
        return this.disk.getOnDiskSize();
    }

    public long getOnDiskSizeInBytes() {
        return this.disk.getOnDiskSizeInBytes();
    }

    public int getTerracottaClusteredSize() {
        return 0;
    }

    public void setInMemoryEvictionPolicy(Policy policy) {
        this.disk.setInMemoryEvictionPolicy(policy);
    }

    public void deregistered(CacheConfiguration config) {
    }

    public void diskCapacityChanged(int oldCapacity, int newCapacity) {
        this.disk.setOnDiskCapacity(newCapacity);
    }

    public void loggingChanged(boolean oldValue, boolean newValue) {
    }

    public void memoryCapacityChanged(int oldCapacity, int newCapacity) {
        this.disk.setInMemoryCapacity(newCapacity);
    }

    public void registered(CacheConfiguration config) {
    }

    public void timeToIdleChanged(long oldTimeToIdle, long newTimeToIdle) {
    }

    public void timeToLiveChanged(long oldTimeToLive, long newTimeToLive) {
    }

    public File getDataFile() {
        return this.disk.getDataFile();
    }

    public File getIndexFile() {
        return this.disk.getIndexFile();
    }

    public Object getMBean() {
        return null;
    }
}

