/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package bugs

import groovy.transform.CompileStatic
import org.junit.Test

import static groovy.test.GroovyAssert.shouldFail

@CompileStatic
final class Groovy8686 {

    @Test
    void testInstanceOfScope1() {
        def err = shouldFail '''
            @groovy.transform.TypeChecked
            def m(obj) {
                boolean isA = (obj instanceof String && obj.equalsIgnoreCase('a'))
                obj.toLowerCase() // typeof(obj) should be Object, not String
            }
        '''
        assert err =~ /Cannot find matching method java.lang.Object#toLowerCase/
    }

    @Test
    void testInstanceOfScope2() {
        def err = shouldFail '''
            @groovy.transform.CompileStatic
            def m(obj) {
                boolean isA = (obj instanceof String && obj.equalsIgnoreCase('a'))
                obj.toLowerCase() // typeof(obj) should be Object, not String
            }
        '''
        assert err =~ /Cannot find matching method java.lang.Object#toLowerCase/
    }
}
