/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Collections;
import java.util.Locale;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.SupportsRoles;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.rest.RESTUtils;

class MetadataObjectRoleOperations
implements SupportsRoles {
    private final RESTClient restClient;
    private final String roleRequestPath;

    MetadataObjectRoleOperations(String metalakeName, MetadataObject metadataObject, RESTClient restClient) {
        this.restClient = restClient;
        this.roleRequestPath = String.format("api/metalakes/%s/objects/%s/%s/roles", RESTUtils.encodeString(metalakeName), metadataObject.type().name().toLowerCase(Locale.ROOT), RESTUtils.encodeString(metadataObject.fullName()));
    }

    @Override
    public String[] listBindingRoleNames() {
        NameListResponse resp = this.restClient.get(this.roleRequestPath, NameListResponse.class, Collections.emptyMap(), ErrorHandlers.roleErrorHandler());
        resp.validate();
        return resp.getNames();
    }
}

