/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.FileRewriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.math.LongMath;
import org.apache.iceberg.util.BinPacking;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class SizeBasedFileRewriter<T extends ContentScanTask<F>, F extends ContentFile<F>>
implements FileRewriter<T, F> {
    private static final Logger LOG = LoggerFactory.getLogger(SizeBasedFileRewriter.class);
    public static final String TARGET_FILE_SIZE_BYTES = "target-file-size-bytes";
    public static final String MIN_FILE_SIZE_BYTES = "min-file-size-bytes";
    public static final double MIN_FILE_SIZE_DEFAULT_RATIO = 0.75;
    public static final String MAX_FILE_SIZE_BYTES = "max-file-size-bytes";
    public static final double MAX_FILE_SIZE_DEFAULT_RATIO = 1.8;
    public static final String MIN_INPUT_FILES = "min-input-files";
    public static final int MIN_INPUT_FILES_DEFAULT = 5;
    public static final String REWRITE_ALL = "rewrite-all";
    public static final boolean REWRITE_ALL_DEFAULT = false;
    public static final String MAX_FILE_GROUP_SIZE_BYTES = "max-file-group-size-bytes";
    public static final long MAX_FILE_GROUP_SIZE_BYTES_DEFAULT = 0x1900000000L;
    private static final long SPLIT_OVERHEAD = 5120L;
    private final Table table;
    private long targetFileSize;
    private long minFileSize;
    private long maxFileSize;
    private int minInputFiles;
    private boolean rewriteAll;
    private long maxGroupSize;
    private int outputSpecId;

    protected SizeBasedFileRewriter(Table table) {
        this.table = table;
    }

    protected abstract long defaultTargetFileSize();

    protected abstract Iterable<T> filterFiles(Iterable<T> var1);

    protected abstract Iterable<List<T>> filterFileGroups(List<List<T>> var1);

    protected Table table() {
        return this.table;
    }

    @Override
    public Set<String> validOptions() {
        return ImmutableSet.of((Object)TARGET_FILE_SIZE_BYTES, (Object)MIN_FILE_SIZE_BYTES, (Object)MAX_FILE_SIZE_BYTES, (Object)MIN_INPUT_FILES, (Object)REWRITE_ALL, (Object)MAX_FILE_GROUP_SIZE_BYTES, (Object[])new String[0]);
    }

    @Override
    public void init(Map<String, String> options) {
        Map<String, Long> sizeThresholds = this.sizeThresholds(options);
        this.targetFileSize = sizeThresholds.get(TARGET_FILE_SIZE_BYTES);
        this.minFileSize = sizeThresholds.get(MIN_FILE_SIZE_BYTES);
        this.maxFileSize = sizeThresholds.get(MAX_FILE_SIZE_BYTES);
        this.minInputFiles = this.minInputFiles(options);
        this.rewriteAll = this.rewriteAll(options);
        this.maxGroupSize = this.maxGroupSize(options);
        this.outputSpecId = this.outputSpecId(options);
        if (this.rewriteAll) {
            LOG.info("Configured to rewrite all provided files in table {}", (Object)this.table.name());
        }
    }

    protected boolean wronglySized(T task) {
        return task.length() < this.minFileSize || task.length() > this.maxFileSize;
    }

    @Override
    public Iterable<List<T>> planFileGroups(Iterable<T> tasks) {
        Iterable<T> filteredTasks = this.rewriteAll ? tasks : this.filterFiles(tasks);
        BinPacking.ListPacker<ContentScanTask> packer = new BinPacking.ListPacker<ContentScanTask>(this.maxGroupSize, 1, false);
        List<List<T>> groups = packer.pack(filteredTasks, ContentScanTask::length);
        return this.rewriteAll ? groups : this.filterFileGroups(groups);
    }

    protected boolean enoughInputFiles(List<T> group) {
        return group.size() > 1 && group.size() >= this.minInputFiles;
    }

    protected boolean enoughContent(List<T> group) {
        return group.size() > 1 && this.inputSize(group) > this.targetFileSize;
    }

    protected boolean tooMuchContent(List<T> group) {
        return this.inputSize(group) > this.maxFileSize;
    }

    protected long inputSize(List<T> group) {
        return group.stream().mapToLong(ContentScanTask::length).sum();
    }

    protected long splitSize(long inputSize) {
        long estimatedSplitSize = inputSize / this.numOutputFiles(inputSize) + 5120L;
        if (estimatedSplitSize < this.targetFileSize) {
            return this.targetFileSize;
        }
        if (estimatedSplitSize > this.writeMaxFileSize()) {
            return this.writeMaxFileSize();
        }
        return estimatedSplitSize;
    }

    protected long numOutputFiles(long inputSize) {
        if (inputSize < this.targetFileSize) {
            return 1L;
        }
        long numFilesWithRemainder = LongMath.divide((long)inputSize, (long)this.targetFileSize, (RoundingMode)RoundingMode.CEILING);
        long numFilesWithoutRemainder = LongMath.divide((long)inputSize, (long)this.targetFileSize, (RoundingMode)RoundingMode.FLOOR);
        long avgFileSizeWithoutRemainder = inputSize / numFilesWithoutRemainder;
        if (LongMath.mod((long)inputSize, (long)this.targetFileSize) > this.minFileSize) {
            return numFilesWithRemainder;
        }
        if ((double)avgFileSizeWithoutRemainder < Math.min(1.1 * (double)this.targetFileSize, (double)this.writeMaxFileSize())) {
            return numFilesWithoutRemainder;
        }
        return numFilesWithRemainder;
    }

    protected long writeMaxFileSize() {
        return (long)((double)this.targetFileSize + (double)(this.maxFileSize - this.targetFileSize) * 0.5);
    }

    protected PartitionSpec outputSpec() {
        return (PartitionSpec)this.table.specs().get(this.outputSpecId);
    }

    protected int outputSpecId() {
        return this.outputSpecId;
    }

    private int outputSpecId(Map<String, String> options) {
        int specId = PropertyUtil.propertyAsInt(options, "output-spec-id", this.table.spec().specId());
        Preconditions.checkArgument((boolean)this.table.specs().containsKey(specId), (String)"Cannot use output spec id %s because the table does not contain a reference to this spec-id.", (int)specId);
        return specId;
    }

    private Map<String, Long> sizeThresholds(Map<String, String> options) {
        long target = PropertyUtil.propertyAsLong(options, TARGET_FILE_SIZE_BYTES, this.defaultTargetFileSize());
        long defaultMin = (long)((double)target * 0.75);
        long min = PropertyUtil.propertyAsLong(options, MIN_FILE_SIZE_BYTES, defaultMin);
        long defaultMax = (long)((double)target * 1.8);
        long max = PropertyUtil.propertyAsLong(options, MAX_FILE_SIZE_BYTES, defaultMax);
        Preconditions.checkArgument((target > 0L ? 1 : 0) != 0, (String)"'%s' is set to %s but must be > 0", (Object)TARGET_FILE_SIZE_BYTES, (long)target);
        Preconditions.checkArgument((min >= 0L ? 1 : 0) != 0, (String)"'%s' is set to %s but must be >= 0", (Object)MIN_FILE_SIZE_BYTES, (long)min);
        Preconditions.checkArgument((target > min ? 1 : 0) != 0, (String)"'%s' (%s) must be > '%s' (%s), all new files will be smaller than the min threshold", (Object)TARGET_FILE_SIZE_BYTES, (Object)target, (Object)MIN_FILE_SIZE_BYTES, (Object)min);
        Preconditions.checkArgument((target < max ? 1 : 0) != 0, (String)"'%s' (%s) must be < '%s' (%s), all new files will be larger than the max threshold", (Object)TARGET_FILE_SIZE_BYTES, (Object)target, (Object)MAX_FILE_SIZE_BYTES, (Object)max);
        HashMap values = Maps.newHashMap();
        values.put(TARGET_FILE_SIZE_BYTES, target);
        values.put(MIN_FILE_SIZE_BYTES, min);
        values.put(MAX_FILE_SIZE_BYTES, max);
        return values;
    }

    private int minInputFiles(Map<String, String> options) {
        int value = PropertyUtil.propertyAsInt(options, MIN_INPUT_FILES, 5);
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"'%s' is set to %s but must be > 0", (Object)MIN_INPUT_FILES, (int)value);
        return value;
    }

    private long maxGroupSize(Map<String, String> options) {
        long value = PropertyUtil.propertyAsLong(options, MAX_FILE_GROUP_SIZE_BYTES, 0x1900000000L);
        Preconditions.checkArgument((value > 0L ? 1 : 0) != 0, (String)"'%s' is set to %s but must be > 0", (Object)MAX_FILE_GROUP_SIZE_BYTES, (long)value);
        return value;
    }

    private boolean rewriteAll(Map<String, String> options) {
        return PropertyUtil.propertyAsBoolean(options, REWRITE_ALL, false);
    }
}

