/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.distributed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.internal.distributed.CollectorManager;
import org.apache.geode.cache.lucene.internal.distributed.LuceneFunctionContext;
import org.apache.geode.cache.lucene.internal.distributed.TopEntries;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesCollector;
import org.apache.geode.cache.lucene.internal.distributed.TopEntriesCollectorManager;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class TopEntriesFunctionCollector
implements ResultCollector<TopEntriesCollector, TopEntries> {
    private static final Logger logger = LogService.getLogger();
    private final CollectorManager<TopEntriesCollector> manager;
    private final String id;
    private final Collection<TopEntriesCollector> subResults = new ArrayList<TopEntriesCollector>();
    private TopEntriesCollector mergedResults;

    public TopEntriesFunctionCollector() {
        this(null);
    }

    public TopEntriesFunctionCollector(LuceneFunctionContext<TopEntriesCollector> context) {
        this(context, null);
    }

    public TopEntriesFunctionCollector(LuceneFunctionContext<TopEntriesCollector> context, InternalCache cache) {
        this.id = cache == null ? String.valueOf(this.hashCode()) : cache.getName();
        int limit = context == null ? 0 : context.getLimit();
        this.manager = context != null && context.getCollectorManager() != null ? context.getCollectorManager() : new TopEntriesCollectorManager(this.id, limit);
    }

    public TopEntries getResult() throws FunctionException {
        return this.aggregateResults();
    }

    public TopEntries getResult(long timeout, TimeUnit unit) throws FunctionException {
        return this.aggregateResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopEntries aggregateResults() {
        Collection<TopEntriesCollector> collection = this.subResults;
        synchronized (collection) {
            if (this.mergedResults != null) {
                return this.mergedResults.getEntries();
            }
            this.mergedResults = this.manager.reduce(this.subResults);
            return this.mergedResults.getEntries();
        }
    }

    public void endResults() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResults() {
        Collection<TopEntriesCollector> collection = this.subResults;
        synchronized (collection) {
            this.subResults.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResult(DistributedMember memberID, TopEntriesCollector resultOfSingleExecution) {
        Collection<TopEntriesCollector> collection = this.subResults;
        synchronized (collection) {
            this.subResults.add(resultOfSingleExecution);
        }
    }

    String id() {
        return this.id;
    }
}

