/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands.lifecycle;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.internal.Assert;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.OperationInvoker;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StartPulseCommand
extends OfflineGfshCommand {
    @CliCommand(value={"start pulse"}, help="Open a new window in the default Web browser with the URL for the Pulse application.")
    @CliMetaData(shellOnly=true, relatedTopic={"Manager", "JMX", "Management-Monitoring"})
    public ResultModel startPulse(@CliOption(key={"url"}, unspecifiedDefaultValue="http://localhost:7070/pulse", help="URL of the Pulse Web application.") String url) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            this.browse(URI.create(url));
            return ResultModel.createInfo("Launched Geode Pulse");
        }
        if (this.isConnectedAndReady()) {
            ObjectName managerObjectName;
            OperationInvoker operationInvoker = this.getGfsh().getOperationInvoker();
            String pulseURL = (String)operationInvoker.getAttribute((managerObjectName = (ObjectName)operationInvoker.getAttribute("GemFire:service=System,type=Distributed", "ManagerObjectName")).toString(), "PulseURL");
            if (StringUtils.isNotBlank((CharSequence)pulseURL)) {
                this.browse(URI.create(pulseURL));
                return ResultModel.createError("Launched Geode Pulse with URL: " + pulseURL);
            }
            String pulseMessage = (String)operationInvoker.getAttribute(managerObjectName.toString(), "StatusMessage");
            return StringUtils.isNotBlank((CharSequence)pulseMessage) ? ResultModel.createError(pulseMessage) : ResultModel.createError("Could not find the URL for Geode Pulse.");
        }
        return ResultModel.createError(CliStrings.format((String)"Gfsh must be connected for launching {0}", (Object)"GemFire Pulse"));
    }

    private void browse(URI uri) throws IOException {
        Assert.assertState((boolean)Desktop.isDesktopSupported(), (String)String.format("Running desktop applications is not supported on %1$s.", System.getProperty("os.name")), (Object[])new Object[0]);
        Desktop.getDesktop().browse(uri);
    }
}

