/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.PdxType;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class PDXRenameCommand
extends GfshCommand {
    @CliCommand(value={"pdx rename"}, help="Renames PDX types in an offline disk store. \n Any pdx types that are renamed will be listed in the output. \n If no renames are done or the disk-store is online then this command will fail.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public ResultModel pdxRename(@CliOption(key={"old"}, mandatory=true, help="If a PDX type's fully qualified class name has a word that matches this text then it will be renamed. Words are delimited by '.' and '$'.") String oldClassName, @CliOption(key={"new"}, mandatory=true, help="The text to replace the word that matched old") String newClassName, @CliOption(key={"disk-store"}, mandatory=true, help="Name of the disk store to operate on") String diskStore, @CliOption(key={"disk-dirs"}, mandatory=true, help="Directories which contain the disk store files") String[] diskDirs) throws Exception {
        File[] dirs = new File[diskDirs.length];
        for (int i = 0; i < diskDirs.length; ++i) {
            dirs[i] = new File(diskDirs[i]);
        }
        Collection results = DiskStoreImpl.pdxRename((String)diskStore, (File[])dirs, (String)oldClassName, (String)newClassName);
        if (results.isEmpty()) {
            return ResultModel.createError(CliStrings.format((String)"No Pdx types found to rename.", (Object[])new Object[0]));
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        for (Object p : results) {
            if (p instanceof PdxType) {
                ((PdxType)p).toStream(printStream, false);
                continue;
            }
            ((EnumInfo)p).toStream(printStream);
        }
        String resultString = CliStrings.format((String)"Successfully renamed pdx types:\n{0}", (Object)outputStream.toString());
        return ResultModel.createInfo(resultString);
    }
}

