/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.AbstractCloseableIOIterator;
import com.healthmarketscience.rmiio.RmiioUtil;
import java.io.BufferedReader;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineIterator
extends AbstractCloseableIOIterator<String> {
    private final BufferedReader _reader;
    private String _next;
    private boolean _trimWhitespace;
    private boolean _skipBlankLines;

    public LineIterator(BufferedReader reader, boolean trimWhitespace, boolean skipBlankLines) throws IOException {
        this._reader = reader;
        this._skipBlankLines = skipBlankLines;
        this._trimWhitespace = trimWhitespace;
        this.getNext();
    }

    private void getNext() throws IOException {
        do {
            this._next = this._reader.readLine();
            if (this._next == null) break;
            if (!this._trimWhitespace) continue;
            this._next = this._next.trim();
        } while (this._skipBlankLines && this._next.length() == 0);
    }

    @Override
    public boolean hasNext() throws IOException {
        return this._next != null;
    }

    @Override
    protected String nextImpl() throws IOException {
        String cur = this._next;
        this.getNext();
        return cur;
    }

    @Override
    protected void closeImpl() {
        RmiioUtil.closeQuietly(this._reader);
    }
}

