/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization.filter;

import java.util.Set;
import java.util.function.Supplier;
import org.apache.geode.internal.serialization.filter.FilterConfiguration;
import org.apache.geode.internal.serialization.filter.GlobalSerialFilter;
import org.apache.geode.internal.serialization.filter.GlobalSerialFilterFactory;
import org.apache.geode.internal.serialization.filter.ReflectiveFacadeGlobalSerialFilterFactory;
import org.apache.geode.internal.serialization.filter.SanctionedSerializables;
import org.apache.geode.internal.serialization.filter.SanctionedSerializablesFilterPattern;
import org.apache.geode.internal.serialization.filter.SerializableObjectConfig;
import org.apache.geode.internal.serialization.filter.UnableToSetSerialFilterException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.TestOnly;

class GlobalSerialFilterConfiguration
implements FilterConfiguration {
    private static final Logger LOGGER = LogService.getLogger();
    private final SerializableObjectConfig serializableObjectConfig;
    private final FilterPatternFactory filterPatternFactory;
    private final Supplier<Set<String>> sanctionedClassesSupplier;
    private final Logger logger;
    private final GlobalSerialFilterFactory globalSerialFilterFactory;

    GlobalSerialFilterConfiguration(SerializableObjectConfig serializableObjectConfig) {
        this(serializableObjectConfig, (pattern, sanctionedClasses) -> new ReflectiveFacadeGlobalSerialFilterFactory().create(pattern, sanctionedClasses));
    }

    @TestOnly
    GlobalSerialFilterConfiguration(SerializableObjectConfig serializableObjectConfig, GlobalSerialFilterFactory globalSerialFilterFactory) {
        this(serializableObjectConfig, LOGGER, globalSerialFilterFactory);
    }

    @TestOnly
    GlobalSerialFilterConfiguration(SerializableObjectConfig serializableObjectConfig, Logger logger, GlobalSerialFilterFactory globalSerialFilterFactory) {
        this(serializableObjectConfig, new DefaultFilterPatternFactory(), () -> SanctionedSerializables.loadSanctionedClassNames(SanctionedSerializables.loadSanctionedSerializablesServices()), logger, globalSerialFilterFactory);
    }

    private GlobalSerialFilterConfiguration(SerializableObjectConfig serializableObjectConfig, FilterPatternFactory filterPatternFactory, Supplier<Set<String>> sanctionedClassesSupplier, Logger logger, GlobalSerialFilterFactory globalSerialFilterFactory) {
        this.serializableObjectConfig = serializableObjectConfig;
        this.filterPatternFactory = filterPatternFactory;
        this.sanctionedClassesSupplier = sanctionedClassesSupplier;
        this.logger = logger;
        this.globalSerialFilterFactory = globalSerialFilterFactory;
    }

    @Override
    public boolean configure() throws UnableToSetSerialFilterException {
        this.serializableObjectConfig.setValidateSerializableObjects(true);
        String pattern = this.filterPatternFactory.create(this.serializableObjectConfig.getSerializableObjectFilterIfEnabled());
        Set<String> sanctionedClasses = this.sanctionedClassesSupplier.get();
        GlobalSerialFilter globalSerialFilter = this.globalSerialFilterFactory.create(pattern, sanctionedClasses);
        globalSerialFilter.setFilter();
        this.logger.info("Global serialization filter is now configured.");
        return true;
    }

    public static class DefaultFilterPatternFactory
    implements FilterPatternFactory {
        @Override
        public String create(String optionalSerializableObjectFilter) {
            return new SanctionedSerializablesFilterPattern().append(optionalSerializableObjectFilter).pattern();
        }
    }

    @FunctionalInterface
    static interface FilterPatternFactory {
        public String create(String var1);
    }
}

