/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util.redaction;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.geode.internal.util.redaction.SensitiveDataDictionary;

class CombinedSensitiveDictionary
implements SensitiveDataDictionary {
    private final Iterable<SensitiveDataDictionary> dictionaries;

    CombinedSensitiveDictionary(SensitiveDataDictionary ... dictionaries) {
        this.dictionaries = Arrays.stream(dictionaries).collect(Collectors.toSet());
    }

    @Override
    public boolean isSensitive(String string) {
        for (SensitiveDataDictionary dictionary : this.dictionaries) {
            if (!dictionary.isSensitive(string)) continue;
            return true;
        }
        return false;
    }
}

