/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net.filewatch;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.commons.lang3.StringUtils;

final class ExtendedAliasKeyManager
extends X509ExtendedKeyManager {
    private final X509ExtendedKeyManager delegate;
    private final String keyAlias;

    ExtendedAliasKeyManager(X509ExtendedKeyManager mgr, String keyAlias) {
        this.delegate = mgr;
        this.keyAlias = keyAlias;
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return this.delegate.getClientAliases(s, principals);
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        if (!StringUtils.isEmpty((CharSequence)this.keyAlias)) {
            return this.keyAlias;
        }
        return this.delegate.chooseClientAlias(strings, principals, socket);
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return this.delegate.getServerAliases(s, principals);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (!StringUtils.isEmpty((CharSequence)this.keyAlias)) {
            PrivateKey key = this.delegate.getPrivateKey(this.keyAlias);
            return this.getKeyAlias(keyType, key);
        }
        return this.delegate.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        if (!StringUtils.isEmpty((CharSequence)this.keyAlias)) {
            return this.delegate.getCertificateChain(this.keyAlias);
        }
        return this.delegate.getCertificateChain(s);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.delegate.getPrivateKey(alias);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] principals, SSLEngine sslEngine) {
        return this.delegate.chooseEngineClientAlias(keyTypes, principals, sslEngine);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] principals, SSLEngine sslEngine) {
        if (!StringUtils.isEmpty((CharSequence)this.keyAlias)) {
            PrivateKey key = this.delegate.getPrivateKey(this.keyAlias);
            return this.getKeyAlias(keyType, key);
        }
        return this.delegate.chooseEngineServerAlias(keyType, principals, sslEngine);
    }

    private String getKeyAlias(String keyType, PrivateKey key) {
        if (key != null) {
            if (key.getAlgorithm().equals(keyType)) {
                return this.keyAlias;
            }
            return null;
        }
        return null;
    }
}

