/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.extension;

import java.util.ArrayList;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.cache.extension.Extensible;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.cache.extension.ExtensionPoint;
import org.apache.geode.internal.util.CollectionUtils;

public class SimpleExtensionPoint<T>
implements ExtensionPoint<T> {
    protected final ArrayList<Extension<T>> extensions = new ArrayList();
    protected final Iterable<Extension<T>> iterable = CollectionUtils.unmodifiableIterable(this.extensions);
    protected final Extensible<T> extensible;
    protected final T target;

    public SimpleExtensionPoint(Extensible<T> extensible, T target) {
        this.extensible = extensible;
        this.target = target;
    }

    @Override
    public Iterable<Extension<T>> getExtensions() {
        return this.iterable;
    }

    @Override
    public void addExtension(Extension<T> extension) {
        this.extensions.add(extension);
    }

    @Override
    public void removeExtension(Extension<T> extension) {
        this.extensions.remove(extension);
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    public void beforeCreate(Cache cache) {
        for (Extension<T> extension : this.extensions) {
            extension.beforeCreate(this.extensible, cache);
        }
    }

    public void fireCreate(Extensible<T> newTarget) {
        for (Extension<T> extension : this.extensions) {
            extension.onCreate(this.extensible, newTarget);
        }
    }
}

