/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import org.apache.geode.internal.cache.BucketRegionQueue;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.entries.AbstractRegionEntry;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.cache.wan.serial.SerialGatewaySenderQueue;

public abstract class AbstractDiskRegionEntry
extends AbstractRegionEntry
implements DiskEntry {
    protected AbstractDiskRegionEntry(RegionEntryContext context, Object value) {
        super(context, value);
    }

    @Override
    public void setValue(RegionEntryContext context, Object v) throws RegionClearedException {
        this.setValue(context, v, null);
    }

    @Override
    public void setValue(RegionEntryContext context, Object value, EntryEventImpl event) throws RegionClearedException {
        DiskEntry.Helper.update(this, (LocalRegion)context, value, event);
        this.setRecentlyUsed(context);
    }

    @Override
    public void setValueWithContext(RegionEntryContext context, Object value) {
        this._setValue(value);
        this.releaseOffHeapRefIfRegionBeingClosedOrDestroyed(context, value);
    }

    @Override
    public void handleValueOverflow(RegionEntryContext context) {
        if (context instanceof BucketRegionQueue || context instanceof SerialGatewaySenderQueue.SerialGatewaySenderQueueMetaRegion) {
            GatewaySenderEventImpl.release(this.getValue());
        }
    }
}

