/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.internal.admin.RegionSnapshot;
import org.apache.geode.internal.admin.remote.RemoteCacheStatistics;
import org.apache.geode.internal.admin.remote.RemoteRegionAttributes;

public class RemoteRegionSnapshot
implements RegionSnapshot,
DataSerializable {
    private static final long serialVersionUID = -2006079857403000280L;
    private String name;
    private RemoteRegionAttributes attributes;
    private RemoteCacheStatistics stats;
    private int entryCount;
    private int subregionCount;
    private Object userAttribute;

    public RemoteRegionSnapshot(Region r) throws CacheException {
        this.name = r.getName();
        RegionAttributes rAttr = r.getAttributes();
        this.attributes = new RemoteRegionAttributes(rAttr);
        this.stats = rAttr.getStatisticsEnabled() ? new RemoteCacheStatistics(r.getStatistics()) : new RemoteCacheStatistics();
        this.attributes = new RemoteRegionAttributes(r.getAttributes());
        Set nameSet = r.keySet();
        this.entryCount = nameSet.size();
        Set<Region<?, ?>> subRegions = r.subregions(false);
        this.subregionCount = subRegions.size();
        Object attr = r.getUserAttribute();
        this.userAttribute = attr != null ? attr.getClass().getName() + "\"" + attr + "\"" : null;
    }

    public RemoteRegionSnapshot() {
    }

    @Override
    public Object getName() {
        return this.name;
    }

    @Override
    public long getLastModifiedTime() {
        return this.stats.getLastModifiedTime();
    }

    @Override
    public long getLastAccessTime() {
        return this.stats.getLastAccessedTime();
    }

    @Override
    public long getNumberOfHits() {
        return this.stats.getHitCount();
    }

    @Override
    public long getNumberOfMisses() {
        return this.stats.getMissCount();
    }

    @Override
    public float getHitRatio() {
        return this.stats.getHitRatio();
    }

    @Override
    public RegionAttributes getAttributes() {
        return this.attributes;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public int getSubregionCount() {
        return this.subregionCount;
    }

    @Override
    public Object getUserAttribute() {
        return this.userAttribute;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RemoteRegionSnapshot) {
            RemoteRegionSnapshot snap = (RemoteRegionSnapshot)other;
            return this.name.equals(snap.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getName().toString();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.name, out);
        DataSerializer.writeObject(this.stats, out);
        DataSerializer.writeObject(this.attributes, out);
        out.writeInt(this.entryCount);
        out.writeInt(this.subregionCount);
        DataSerializer.writeObject(this.userAttribute, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.name = DataSerializer.readString(in);
        this.stats = (RemoteCacheStatistics)DataSerializer.readObject(in);
        this.attributes = (RemoteRegionAttributes)DataSerializer.readObject(in);
        this.entryCount = in.readInt();
        this.subregionCount = in.readInt();
        this.userAttribute = DataSerializer.readObject(in);
    }
}

