/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.Comparator;
import java.util.List;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.cache.VMCachedDeserializable;
import org.apache.geode.pdx.internal.PdxString;

public class OrderByComparator
implements Comparator {
    private final ObjectType objType;
    private final ExecutionContext context;
    protected final List<CompiledSortCriterion> orderByAttrs;

    public OrderByComparator(List<CompiledSortCriterion> orderByAttrs, ObjectType objType, ExecutionContext context) {
        this.objType = objType;
        this.context = context;
        this.orderByAttrs = orderByAttrs;
    }

    protected Object[] evaluateSortCriteria(Object value) {
        Object[] array = null;
        if (this.orderByAttrs != null) {
            array = new Object[this.orderByAttrs.size()];
            int i = 0;
            for (CompiledSortCriterion csc : this.orderByAttrs) {
                Object[] arr = new Object[]{csc.evaluate(value, this.context), csc.getCriterion()};
                array[i++] = arr;
            }
        }
        return array;
    }

    protected int evaluateSortCriteria(Object value1, Object value2) {
        int result = -1;
        if (this.orderByAttrs != null) {
            for (CompiledSortCriterion csc : this.orderByAttrs) {
                Object sortCriteriaForValue2;
                Object sortCriteriaForValue1 = csc.evaluate(value1, this.context);
                result = this.compareHelperMethod(sortCriteriaForValue1, sortCriteriaForValue2 = csc.evaluate(value2, this.context));
                if (result == 0) continue;
                if (!csc.getCriterion()) break;
                result *= -1;
                break;
            }
        }
        return result;
    }

    public int compare(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        assert (!(obj1 instanceof VMCachedDeserializable) && !(obj2 instanceof VMCachedDeserializable));
        if (this.objType.isStructType() && obj1 instanceof Object[] && obj2 instanceof Object[] || !this.objType.isStructType()) {
            int result = this.evaluateSortCriteria(obj1, obj2);
            if (result != 0 && this.orderByAttrs != null) {
                return result;
            }
            if (QueryObserverHolder.getInstance() != null) {
                QueryObserverHolder.getInstance().orderByColumnsEqual();
            }
            if (this.objType.isStructType()) {
                int i = 0;
                for (Object o1 : (Object[])obj1) {
                    Object o2;
                    if ((result = this.compareHelperMethod(o1, o2 = ((Object[])obj2)[i++])) == 0) continue;
                    return result;
                }
                return 0;
            }
            return this.compareTwoStrings(obj1, obj2);
        }
        throw new ClassCastException();
    }

    void addEvaluatedSortCriteria(Object row, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
    }

    private int compareHelperMethod(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return this.compareIfOneOrMoreNull(obj1, obj2);
        }
        if (obj1 == QueryService.UNDEFINED || obj2 == QueryService.UNDEFINED) {
            return this.compareIfOneOrMoreQueryServiceUndefined(obj1, obj2);
        }
        return this.compareTwoObjects(obj1, obj2);
    }

    private int compareIfOneOrMoreNull(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null ? 0 : -1;
        }
        return 1;
    }

    private int compareIfOneOrMoreQueryServiceUndefined(Object obj1, Object obj2) {
        if (obj1 == QueryService.UNDEFINED) {
            return obj2 == QueryService.UNDEFINED ? 0 : -1;
        }
        return 1;
    }

    private int compareTwoObjects(Object obj1, Object obj2) {
        if (obj1 instanceof Number && obj2 instanceof Number) {
            return this.compareTwoNumbers(obj1, obj2);
        }
        return this.compareTwoStrings(obj1, obj2);
    }

    private int compareTwoNumbers(Object obj1, Object obj2) {
        Number num1 = (Number)obj1;
        Number num2 = (Number)obj2;
        return Double.compare(num1.doubleValue(), num2.doubleValue());
    }

    private int compareTwoStrings(Object obj1, Object obj2) {
        if (obj1 instanceof PdxString && obj2 instanceof String) {
            obj2 = new PdxString((String)obj2);
        } else if (obj2 instanceof PdxString && obj1 instanceof String) {
            obj1 = new PdxString((String)obj1);
        }
        if (obj1 instanceof Comparable) {
            return ((Comparable)obj1).compareTo(obj2);
        }
        return obj1.equals(obj2) ? 0 : -1;
    }
}

