/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.geode.internal.inet.LocalHostUtil;

@Deprecated
public class InetAddressUtils {
    private InetAddressUtils() {
    }

    public static boolean isIPLiteral(String hostName) {
        return InetAddressValidator.getInstance().isValid(hostName);
    }

    public static String toHostString(Object val) {
        if (val instanceof String) {
            return InetAddressUtils.trimLeadingSlash((String)val);
        }
        if (val instanceof InetAddress) {
            return ((InetAddress)val).getHostAddress();
        }
        return InetAddressUtils.trimLeadingSlash(val.toString());
    }

    public static String validateHost(String host) {
        try {
            return InetAddressUtils.validateHostOrThrow(host);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    protected static String trimLeadingSlash(String value) {
        if (value == null) {
            return "";
        }
        while (value.indexOf(47) > -1) {
            value = value.substring(value.indexOf(47) + 1);
        }
        return value;
    }

    protected static InetAddress toInetAddressOrThrow(String host) throws UnknownHostException {
        if (host == null || host.isEmpty()) {
            return null;
        }
        if (host.contains("/")) {
            return InetAddress.getByName(host.substring(host.indexOf(47) + 1));
        }
        return InetAddress.getByName(host);
    }

    protected static String validateHostOrThrow(String host) throws UnknownHostException {
        if (host == null || host.isEmpty()) {
            return null;
        }
        InetAddress.getByName(InetAddressUtils.trimLeadingSlash(host));
        return host;
    }

    private static InetAddress getLocalHost() {
        try {
            return LocalHostUtil.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new AssertionError("Failed to get local host", e);
        }
    }
}

