/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.jobs.transferfeechargeforloans;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.jobs.exception.JobExecutionException;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.AccountTransferDTO;
import org.apache.fineract.portfolio.account.data.PortfolioAccountData;
import org.apache.fineract.portfolio.account.domain.AccountTransferType;
import org.apache.fineract.portfolio.account.service.AccountAssociationsReadPlatformService;
import org.apache.fineract.portfolio.account.service.AccountTransfersWritePlatformService;
import org.apache.fineract.portfolio.charge.domain.ChargePaymentMode;
import org.apache.fineract.portfolio.loanaccount.data.LoanChargeData;
import org.apache.fineract.portfolio.loanaccount.data.LoanInstallmentChargeData;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeReadPlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class TransferFeeChargeForLoansTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransferFeeChargeForLoansTasklet.class);
    private final LoanChargeReadPlatformService loanChargeReadPlatformService;
    private final AccountAssociationsReadPlatformService accountAssociationsReadPlatformService;
    private final AccountTransfersWritePlatformService accountTransfersWritePlatformService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Collection chargeDatas = this.loanChargeReadPlatformService.retrieveLoanChargesForFeePayment(ChargePaymentMode.ACCOUNT_TRANSFER.getValue(), LoanStatus.ACTIVE.getValue());
        boolean isRegularTransaction = true;
        ArrayList errors = new ArrayList();
        if (chargeDatas != null) {
            for (LoanChargeData chargeData : chargeDatas) {
                if (chargeData.isInstallmentFee()) {
                    List chargePerInstallments = this.loanChargeReadPlatformService.retrieveInstallmentLoanCharges(chargeData.getId(), true);
                    PortfolioAccountData portfolioAccountData = null;
                    for (LoanInstallmentChargeData installmentChargeData : chargePerInstallments) {
                        if (DateUtils.isDateInTheFuture((LocalDate)installmentChargeData.getDueDate())) continue;
                        if (portfolioAccountData == null) {
                            portfolioAccountData = this.accountAssociationsReadPlatformService.retriveLoanLinkedAssociation(chargeData.getLoanId());
                        }
                        boolean isExceptionForBalanceCheck = false;
                        AccountTransferDTO accountTransferDTO = new AccountTransferDTO(DateUtils.getBusinessLocalDate(), installmentChargeData.getAmountOutstanding(), PortfolioAccountType.SAVINGS, PortfolioAccountType.LOAN, portfolioAccountData.getId(), chargeData.getLoanId(), "Loan Charge Payment", null, null, null, null, LoanTransactionType.CHARGE_PAYMENT.getValue(), chargeData.getId(), installmentChargeData.getInstallmentNumber(), AccountTransferType.CHARGE_PAYMENT.getValue(), null, null, ExternalId.empty(), null, null, null, Boolean.valueOf(true), Boolean.valueOf(false));
                        this.transferFeeCharge(accountTransferDTO, errors);
                    }
                    continue;
                }
                if (chargeData.getDueDate() == null || DateUtils.isDateInTheFuture((LocalDate)chargeData.getDueDate())) continue;
                PortfolioAccountData portfolioAccountData = this.accountAssociationsReadPlatformService.retriveLoanLinkedAssociation(chargeData.getLoanId());
                boolean isExceptionForBalanceCheck = false;
                AccountTransferDTO accountTransferDTO = new AccountTransferDTO(DateUtils.getBusinessLocalDate(), chargeData.getAmountOutstanding(), PortfolioAccountType.SAVINGS, PortfolioAccountType.LOAN, portfolioAccountData.getId(), chargeData.getLoanId(), "Loan Charge Payment", null, null, null, null, LoanTransactionType.CHARGE_PAYMENT.getValue(), chargeData.getId(), null, AccountTransferType.CHARGE_PAYMENT.getValue(), null, null, ExternalId.empty(), null, null, null, Boolean.valueOf(true), Boolean.valueOf(false));
                this.transferFeeCharge(accountTransferDTO, errors);
            }
        }
        if (!errors.isEmpty()) {
            throw new JobExecutionException(errors);
        }
        return RepeatStatus.FINISHED;
    }

    private void transferFeeCharge(AccountTransferDTO accountTransferDTO, List<Throwable> errors) {
        try {
            this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
        }
        catch (RuntimeException e) {
            log.error("Exception while paying charge {} for loan id {}", new Object[]{accountTransferDTO.getChargeId(), accountTransferDTO.getToAccountId(), e});
            errors.add(e);
        }
    }

    @Generated
    public TransferFeeChargeForLoansTasklet(LoanChargeReadPlatformService loanChargeReadPlatformService, AccountAssociationsReadPlatformService accountAssociationsReadPlatformService, AccountTransfersWritePlatformService accountTransfersWritePlatformService) {
        this.loanChargeReadPlatformService = loanChargeReadPlatformService;
        this.accountAssociationsReadPlatformService = accountAssociationsReadPlatformService;
        this.accountTransfersWritePlatformService = accountTransfersWritePlatformService;
    }
}

