/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.monetary.starter;

import org.apache.fineract.organisation.monetary.domain.ApplicationCurrencyRepositoryWrapper;
import org.apache.fineract.organisation.monetary.domain.OrganisationCurrencyRepository;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformServiceImpl;
import org.apache.fineract.organisation.monetary.service.CurrencyWritePlatformService;
import org.apache.fineract.organisation.monetary.service.CurrencyWritePlatformServiceJpaRepositoryImpl;
import org.apache.fineract.organisation.monetary.service.OrganisationCurrencyReadPlatformService;
import org.apache.fineract.organisation.monetary.service.OrganisationCurrencyReadPlatformServiceImpl;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class OrganisationMonetaryConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CurrencyReadPlatformService.class})
    public CurrencyReadPlatformService currencyReadPlatformService(JdbcTemplate jdbcTemplate) {
        return new CurrencyReadPlatformServiceImpl(jdbcTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(value={CurrencyWritePlatformService.class})
    public CurrencyWritePlatformService currencyWritePlatformService(ApplicationCurrencyRepositoryWrapper applicationCurrencyRepository, OrganisationCurrencyRepository organisationCurrencyRepository, LoanProductReadPlatformService loanProductService, SavingsProductReadPlatformService savingsProductService, ChargeReadPlatformService chargeService) {
        return new CurrencyWritePlatformServiceJpaRepositoryImpl(applicationCurrencyRepository, organisationCurrencyRepository, loanProductService, savingsProductService, chargeService);
    }

    @Bean
    @ConditionalOnMissingBean(value={OrganisationCurrencyReadPlatformService.class})
    public OrganisationCurrencyReadPlatformService organisationCurrencyReadPlatformService(CurrencyReadPlatformService currencyReadPlatformService) {
        return new OrganisationCurrencyReadPlatformServiceImpl(currencyReadPlatformService);
    }
}

