/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.jersey.serializer;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.util.List;
import org.apache.fineract.infrastructure.core.jersey.converter.JsonConverter;
import org.apache.fineract.infrastructure.core.jersey.converter.LocalDateJsonConverter;
import org.apache.fineract.infrastructure.core.jersey.serializer.JacksonSerializerAdapter;
import org.apache.fineract.infrastructure.core.jersey.serializer.legacy.JacksonLocalDateArraySerializer;
import org.apache.fineract.infrastructure.core.jersey.serializer.legacy.JsonLocalDateArrayFormat;

@SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_BAD_FIELD_STORE"})
public class JacksonLocalDateBeanSerializerModifier
extends BeanSerializerModifier {
    private final JsonSerializer<?> localDateSerializer = new JacksonSerializerAdapter((JsonConverter)new LocalDateJsonConverter());
    private final JsonSerializer<?> localDateArraySerializer = new JacksonLocalDateArraySerializer();

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        if (beanDesc.getBeanClass().isAnnotationPresent(JsonLocalDateArrayFormat.class)) {
            this.assignLocalDateSerializer(beanProperties, this.localDateArraySerializer);
        } else {
            this.assignLocalDateSerializer(beanProperties, this.localDateSerializer);
        }
        return beanProperties;
    }

    private void assignLocalDateSerializer(List<BeanPropertyWriter> beanProperties, JsonSerializer<Object> serializer) {
        for (BeanPropertyWriter writer : beanProperties) {
            if (!LocalDate.class.equals((Object)writer.getPropertyType())) continue;
            writer.assignSerializer(serializer);
        }
    }
}

