/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.mapreduce;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.redisson.api.RedissonClient;
import org.redisson.api.annotation.RInject;

public abstract class BaseMapperTask<KOut, VOut>
implements Runnable,
Serializable {
    private static final long serialVersionUID = 6224632826989873592L;
    @RInject
    protected RedissonClient redisson;
    protected Class<?> objectClass;
    protected List<String> objectNames = new ArrayList<String>();
    protected Class<?> objectCodecClass;
    protected int workersAmount;
    protected String collectorMapName;
    protected long timeout;

    public BaseMapperTask() {
    }

    public BaseMapperTask(Class<?> objectClass, Class<?> objectCodecClass) {
        this.objectClass = objectClass;
        this.objectCodecClass = objectCodecClass;
    }

    public void addObjectName(String objectName) {
        this.objectNames.add(objectName);
    }

    public void clearObjectNames() {
        this.objectNames.clear();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setWorkersAmount(int workersAmount) {
        this.workersAmount = workersAmount;
    }

    public void setCollectorMapName(String collatorMapName) {
        this.collectorMapName = collatorMapName;
    }
}

