/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.options;

import java.time.Duration;
import org.redisson.api.options.BaseMapOptions;
import org.redisson.api.options.LocalCachedMapOptions;

public final class LocalCachedMapParams<K, V>
extends BaseMapOptions<LocalCachedMapOptions<K, V>, K, V>
implements LocalCachedMapOptions<K, V> {
    private final String name;
    private LocalCachedMapOptions.ReconnectionStrategy reconnectionStrategy = LocalCachedMapOptions.ReconnectionStrategy.NONE;
    private LocalCachedMapOptions.SyncStrategy syncStrategy = LocalCachedMapOptions.SyncStrategy.INVALIDATE;
    private LocalCachedMapOptions.EvictionPolicy evictionPolicy = LocalCachedMapOptions.EvictionPolicy.NONE;
    private int cacheSize;
    private long timeToLiveInMillis;
    private long maxIdleInMillis;
    private LocalCachedMapOptions.CacheProvider cacheProvider = LocalCachedMapOptions.CacheProvider.REDISSON;
    private LocalCachedMapOptions.StoreMode storeMode = LocalCachedMapOptions.StoreMode.LOCALCACHE_REDIS;
    private boolean storeCacheMiss;
    private LocalCachedMapOptions.ExpirationEventPolicy expirationEventPolicy = LocalCachedMapOptions.ExpirationEventPolicy.SUBSCRIBE_WITH_KEYEVENT_PATTERN;
    private boolean useObjectAsCacheKey;
    private boolean useTopicPattern;

    LocalCachedMapParams(String name) {
        this.name = name;
    }

    public LocalCachedMapOptions.CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public LocalCachedMapOptions.EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public long getTimeToLiveInMillis() {
        return this.timeToLiveInMillis;
    }

    public long getMaxIdleInMillis() {
        return this.maxIdleInMillis;
    }

    @Override
    public LocalCachedMapParams<K, V> cacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public LocalCachedMapOptions.ReconnectionStrategy getReconnectionStrategy() {
        return this.reconnectionStrategy;
    }

    public LocalCachedMapOptions.SyncStrategy getSyncStrategy() {
        return this.syncStrategy;
    }

    @Override
    public LocalCachedMapParams<K, V> reconnectionStrategy(LocalCachedMapOptions.ReconnectionStrategy reconnectionStrategy) {
        if (reconnectionStrategy == null) {
            throw new NullPointerException("reconnectionStrategy can't be null");
        }
        this.reconnectionStrategy = reconnectionStrategy;
        return this;
    }

    @Override
    public LocalCachedMapParams<K, V> syncStrategy(LocalCachedMapOptions.SyncStrategy syncStrategy) {
        if (syncStrategy == null) {
            throw new NullPointerException("syncStrategy can't be null");
        }
        this.syncStrategy = syncStrategy;
        return this;
    }

    @Override
    public LocalCachedMapParams<K, V> evictionPolicy(LocalCachedMapOptions.EvictionPolicy evictionPolicy) {
        if (evictionPolicy == null) {
            throw new NullPointerException("evictionPolicy can't be null");
        }
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    @Override
    public LocalCachedMapParams<K, V> timeToLive(Duration ttl) {
        this.timeToLiveInMillis = ttl.toMillis();
        return this;
    }

    @Override
    public LocalCachedMapParams<K, V> maxIdle(Duration idleTime) {
        this.maxIdleInMillis = idleTime.toMillis();
        return this;
    }

    public LocalCachedMapOptions.StoreMode getStoreMode() {
        return this.storeMode;
    }

    @Override
    public LocalCachedMapParams<K, V> storeMode(LocalCachedMapOptions.StoreMode storeMode) {
        this.storeMode = storeMode;
        return this;
    }

    @Override
    public LocalCachedMapParams<K, V> cacheProvider(LocalCachedMapOptions.CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
        return this;
    }

    public boolean isStoreCacheMiss() {
        return this.storeCacheMiss;
    }

    @Override
    public LocalCachedMapParams<K, V> storeCacheMiss(boolean storeCacheMiss) {
        this.storeCacheMiss = storeCacheMiss;
        return this;
    }

    @Override
    public LocalCachedMapParams<K, V> useKeyEventsPattern(boolean useKeyEventsPattern) {
        this.expirationEventPolicy = useKeyEventsPattern ? LocalCachedMapOptions.ExpirationEventPolicy.SUBSCRIBE_WITH_KEYEVENT_PATTERN : LocalCachedMapOptions.ExpirationEventPolicy.SUBSCRIBE_WITH_KEYSPACE_CHANNEL;
        return this;
    }

    @Override
    public LocalCachedMapOptions<K, V> expirationEventPolicy(LocalCachedMapOptions.ExpirationEventPolicy expirationEventPolicy) {
        this.expirationEventPolicy = expirationEventPolicy;
        return this;
    }

    @Override
    public LocalCachedMapOptions<K, V> useObjectAsCacheKey(boolean useObjectAsCacheKey) {
        this.useObjectAsCacheKey = useObjectAsCacheKey;
        return this;
    }

    @Override
    public LocalCachedMapOptions<K, V> useTopicPattern(boolean value) {
        this.useTopicPattern = value;
        return this;
    }

    public LocalCachedMapOptions.ExpirationEventPolicy getExpirationEventPolicy() {
        return this.expirationEventPolicy;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUseObjectAsCacheKey() {
        return this.useObjectAsCacheKey;
    }

    public boolean isUseTopicPattern() {
        return this.useTopicPattern;
    }
}

