/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Objects;

public final class StringMatchUtils {
    private StringMatchUtils() {
    }

    public static int indexOf(String str, char[] chars) {
        Objects.requireNonNull(str, "str");
        Objects.requireNonNull(chars, "chars");
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!StringMatchUtils.contains(c, chars)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(char c, char[] validChars) {
        Objects.requireNonNull(validChars, "validChars");
        for (char validCh : validChars) {
            if (validCh != c) continue;
            return true;
        }
        return false;
    }

    public static int endsWithCountMatches(String str, String postfix) {
        boolean found;
        Objects.requireNonNull(str, "str");
        if (StringUtils.isEmpty((String)postfix)) {
            return 0;
        }
        int postFixLength = postfix.length();
        int count = 0;
        int lastOffset = str.length() - postFixLength;
        int length = str.length();
        for (int i = lastOffset; i < length && (found = str.startsWith(postfix, i)); i -= postFixLength) {
            ++count;
        }
        return count;
    }

    public static int startsWithCountMatches(String str, char prefix) {
        char c;
        if (StringUtils.isEmpty((String)str)) {
            return 0;
        }
        int count = 0;
        int length = str.length();
        for (int i = 0; i < length && (c = str.charAt(i)) == prefix; ++i) {
            ++count;
        }
        return count;
    }

    static void appendAndReplace(String str, int startOffset, char oldChar, char newChar, StringBuilder output) {
        Objects.requireNonNull(str, "str");
        Objects.requireNonNull(output, "output");
        for (int i = startOffset; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == oldChar) {
                output.append(newChar);
                continue;
            }
            output.append(c);
        }
    }

    public static boolean startWith(String str1, String str2) {
        if (str1 == null) {
            return false;
        }
        return str1.startsWith(str2);
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == null) {
            return false;
        }
        return str1.equals(str2);
    }
}

