/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.collector.jvmgc;

import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.jvmgc.BasicJvmGcMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.JvmGcDetailedMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.JvmGcMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.DetailedGarbageCollectorMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.DetailedGarbageCollectorMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.DetailedMemoryMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.DetailedMemoryMetricSnapshot;
import java.util.Objects;

public class DetailedJvmGcMetricCollector
implements AgentStatMetricCollector<JvmGcMetricSnapshot> {
    private final BasicJvmGcMetricCollector jvmGcMetricCollector;
    private final DetailedMemoryMetric detailedMemoryMetric;
    private final DetailedGarbageCollectorMetric detailedGarbageCollectorMetric;

    public DetailedJvmGcMetricCollector(BasicJvmGcMetricCollector jvmGcMetricCollector, DetailedMemoryMetric detailedMemoryMetric, DetailedGarbageCollectorMetric detailedGarbageCollectorMetric) {
        this.jvmGcMetricCollector = Objects.requireNonNull(jvmGcMetricCollector, "jvmGcMetricCollector");
        this.detailedMemoryMetric = Objects.requireNonNull(detailedMemoryMetric, "detailedMemoryMetric");
        this.detailedGarbageCollectorMetric = Objects.requireNonNull(detailedGarbageCollectorMetric, "detailedGarbageCollectorMetric");
    }

    @Override
    public JvmGcMetricSnapshot collect() {
        JvmGcMetricSnapshot jvmGcMetricSnapshot = this.jvmGcMetricCollector.collect();
        DetailedMemoryMetricSnapshot detailedMemoryMetricSnapshot = this.detailedMemoryMetric.getSnapshot();
        DetailedGarbageCollectorMetricSnapshot detailedGarbageCollectorMetricSnapshot = this.detailedGarbageCollectorMetric.getSnapshot();
        JvmGcDetailedMetricSnapshot jvmGcDetailedMetricSnapshot = new JvmGcDetailedMetricSnapshot();
        jvmGcDetailedMetricSnapshot.setJvmPoolNewGenUsed(detailedMemoryMetricSnapshot.getNewGenUsage());
        jvmGcDetailedMetricSnapshot.setJvmPoolOldGenUsed(detailedMemoryMetricSnapshot.getOldGenUsage());
        jvmGcDetailedMetricSnapshot.setJvmPoolSurvivorSpaceUsed(detailedMemoryMetricSnapshot.getSurvivorSpaceUsage());
        jvmGcDetailedMetricSnapshot.setJvmPoolCodeCacheUsed(detailedMemoryMetricSnapshot.getCodeCacheUsage());
        jvmGcDetailedMetricSnapshot.setJvmPoolPermGenUsed(detailedMemoryMetricSnapshot.getPermGenUsage());
        jvmGcDetailedMetricSnapshot.setJvmPoolMetaspaceUsed(detailedMemoryMetricSnapshot.getMetaspaceUsage());
        jvmGcDetailedMetricSnapshot.setJvmGcNewCount(detailedGarbageCollectorMetricSnapshot.getGcNewCount());
        jvmGcDetailedMetricSnapshot.setJvmGcNewTime(detailedGarbageCollectorMetricSnapshot.getGcNewTime());
        jvmGcMetricSnapshot.setJvmGcDetailed(jvmGcDetailedMetricSnapshot);
        return jvmGcMetricSnapshot;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DetailedJvmGcMetricCollector{");
        sb.append("jvmGcMetricCollector=").append(this.jvmGcMetricCollector);
        sb.append(", detailedMemoryMetric=").append(this.detailedMemoryMetric);
        sb.append(", detailedGarbageCollectorMetric=").append(this.detailedGarbageCollectorMetric);
        sb.append('}');
        return sb.toString();
    }
}

