/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.scanner;

import com.navercorp.pinpoint.profiler.instrument.scanner.JarFileScanner;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JarFileRepository {
    private final JarFileScanner[] scanners;

    public JarFileRepository(List<String> jarFilePathList) {
        this.scanners = this.newJarScanner(jarFilePathList);
    }

    private JarFileScanner[] newJarScanner(List<String> jarFilePathList) {
        Objects.requireNonNull(jarFilePathList, "jarFilePathList");
        ArrayList<JarFileScanner> jarFileList = new ArrayList<JarFileScanner>(jarFilePathList.size());
        for (String jarFilePath : jarFilePathList) {
            JarFileScanner jarFileScanner = new JarFileScanner(jarFilePath);
            jarFileList.add(jarFileScanner);
        }
        return jarFileList.toArray(new JarFileScanner[0]);
    }

    public InputStream openStream(String resourceName) {
        Objects.requireNonNull(resourceName, "resourceName");
        for (JarFileScanner scanner : this.scanners) {
            InputStream inputStream = scanner.openStream(resourceName);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    public void close() {
        for (JarFileScanner scanner : this.scanners) {
            scanner.close();
        }
    }
}

