/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.common.profiler.message.MessageConverter;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.grpc.trace.PSpan;
import com.navercorp.pinpoint.grpc.trace.PSpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.compress.SpanProcessor;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcSpanMessageConverter;
import com.navercorp.pinpoint.profiler.context.grpc.config.SpanUriGetter;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.SpanMessageMapper;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.ApplicationServerType;
import java.util.Objects;

public class GrpcSpanMessageConverterProvider
implements Provider<MessageConverter<SpanType, GeneratedMessageV3>> {
    private final String agentId;
    private final short applicationServiceTypeCode;
    private final SpanProcessor<PSpan.Builder, PSpanChunk.Builder> spanPostProcessor;
    private final SpanUriGetter spanUriGetter;
    private final SpanMessageMapper mapper;

    @Inject
    public GrpcSpanMessageConverterProvider(@AgentId String agentId, @ApplicationServerType ServiceType applicationServiceType, SpanProcessor<PSpan.Builder, PSpanChunk.Builder> spanPostProcessor, SpanUriGetter spanUriGetter, SpanMessageMapper spanMessageMapper) {
        this.agentId = Objects.requireNonNull(agentId, "agentId");
        this.applicationServiceTypeCode = applicationServiceType.getCode();
        this.spanPostProcessor = Objects.requireNonNull(spanPostProcessor, "spanPostProcessor");
        this.spanUriGetter = Objects.requireNonNull(spanUriGetter, "spanUriGetter");
        this.mapper = Objects.requireNonNull(spanMessageMapper, "spanMessageMapper");
    }

    public MessageConverter<SpanType, GeneratedMessageV3> get() {
        return new GrpcSpanMessageConverter(this.agentId, this.applicationServiceTypeCode, this.spanPostProcessor, this.mapper);
    }
}

