/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.active;

import com.navercorp.pinpoint.profiler.context.active.ActiveTraceSnapshot;
import com.navercorp.pinpoint.profiler.context.id.LocalTraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import java.util.Objects;

public class DefaultActiveTraceSnapshot
implements ActiveTraceSnapshot {
    private final LocalTraceRoot traceRoot;

    public static ActiveTraceSnapshot of(LocalTraceRoot localTraceRoot) {
        return new DefaultActiveTraceSnapshot(localTraceRoot);
    }

    DefaultActiveTraceSnapshot(LocalTraceRoot traceRoot) {
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
    }

    @Override
    public long getLocalTransactionId() {
        return this.traceRoot.getLocalTransactionId();
    }

    @Override
    public long getStartTime() {
        return this.traceRoot.getTraceStartTime();
    }

    @Override
    public long getThreadId() {
        return this.traceRoot.getShared().getThreadId();
    }

    @Override
    public boolean isSampled() {
        return this.isRemote();
    }

    @Override
    public String getTransactionId() {
        if (this.isRemote()) {
            return ((TraceRoot)this.traceRoot).getTraceId().getTransactionId();
        }
        return null;
    }

    @Override
    public String getEntryPoint() {
        if (this.isRemote()) {
            return this.traceRoot.getShared().getRpcName();
        }
        return null;
    }

    private boolean isRemote() {
        return this.traceRoot instanceof TraceRoot;
    }

    public String toString() {
        return "SampledActiveTraceSnapshot{traceRoot=" + this.traceRoot + '}';
    }
}

