/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.AsyncContexts;
import com.navercorp.pinpoint.profiler.context.AsyncId;
import com.navercorp.pinpoint.profiler.context.AsyncScopeUtils;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.Reference;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultAsyncContext
implements AsyncContext {
    private static final Logger logger = LogManager.getLogger(DefaultAsyncContext.class);
    private final TraceRoot traceRoot;
    private final AsyncId asyncId;
    private final AsyncContexts.Remote remote;
    @Nullable
    private final AsyncState asyncState;

    DefaultAsyncContext(AsyncContexts.Remote remote, TraceRoot traceRoot, AsyncId asyncId, @Nullable AsyncState asyncState) {
        this.remote = Objects.requireNonNull(remote, "remote");
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
        this.asyncId = Objects.requireNonNull(asyncId, "asyncId");
        this.asyncState = asyncState;
    }

    public TraceRoot getTraceRoot() {
        return this.traceRoot;
    }

    public Trace continueAsyncTraceObject() {
        Reference<Trace> reference = this.remote.binder().get();
        Trace nestedTrace = reference.get();
        if (nestedTrace != null) {
            if (nestedTrace.canSampled()) {
                return nestedTrace;
            }
            return null;
        }
        return this.newAsyncContextTrace(reference);
    }

    private Trace newAsyncContextTrace(Reference<Trace> reference) {
        LocalAsyncId localAsyncId = this.asyncId.nextLocalAsyncId();
        Trace asyncTrace = this.remote.asyncTraceContext().continueAsyncContextTraceObject(this.traceRoot, localAsyncId);
        this.bind(reference, asyncTrace);
        if (logger.isDebugEnabled()) {
            logger.debug("asyncTraceContext.continuAsyncTraceObject(e) AsyncTrace:{}", (Object)asyncTrace);
        }
        if (AsyncScopeUtils.nested(asyncTrace, "##ASYNC_TRACE_SCOPE")) {
            return null;
        }
        SpanEventRecorder recorder = asyncTrace.currentSpanEventRecorder();
        if (recorder != null) {
            recorder.recordServiceType(ServiceType.ASYNC);
            recorder.recordApiId(this.remote.asyncMethodApiId());
        }
        return asyncTrace;
    }

    private void bind(Reference<Trace> reference, Trace asyncTrace) {
        Assert.state((reference.get() == null ? 1 : 0) != 0, (String)"traceReference is  null");
        reference.set(asyncTrace);
    }

    public Trace currentAsyncTraceObject() {
        Reference<Trace> reference = this.remote.binder().get();
        Trace trace = reference.get();
        if (trace == null) {
            return null;
        }
        if (trace.canSampled()) {
            return trace;
        }
        return null;
    }

    public void close() {
        this.remote.binder().remove();
    }

    public boolean finish() {
        AsyncState copy = this.asyncState;
        if (copy != null) {
            copy.finish();
            return true;
        }
        return false;
    }

    @Nullable
    public AsyncState getAsyncState() {
        return this.asyncState;
    }

    public String toString() {
        return "DefaultAsyncContext{asyncId=" + this.asyncId + ", traceRoot=" + this.traceRoot + ", asyncState=" + this.asyncState + '}';
    }
}

