/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.api.internal;

import io.openmessaging.api.MessagingAccessPoint;
import io.openmessaging.api.OMSResponseStatus;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class MessagingAccessPointAdapter {
    public static MessagingAccessPoint getMessagingAccessPoint(Properties attributes) {
        String driverImpl = MessagingAccessPointAdapter.parseDriverImpl(attributes.getProperty("driver"), attributes);
        attributes.put("driverImpl", driverImpl);
        try {
            Class<?> driverImplClass = Class.forName(driverImpl);
            Constructor<?> constructor = driverImplClass.getConstructor(Properties.class);
            MessagingAccessPoint vendorImpl = (MessagingAccessPoint)constructor.newInstance(attributes);
            return vendorImpl;
        }
        catch (Throwable e) {
            throw OMSResponseStatus.generateException(OMSResponseStatus.STATUS_10000);
        }
    }

    private static String parseDriverImpl(String driverType, Properties attributes) {
        if (attributes.containsKey("driverImpl")) {
            return attributes.getProperty("driverImpl");
        }
        return "io.openmessaging." + driverType + ".MessagingAccessPointImpl";
    }
}

