/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

enum BootLogLevel {
    ERROR(40),
    WARN(30),
    INFO(20),
    DEBUG(10),
    TRACE(0);

    private final int value;

    private BootLogLevel(int value) {
        this.value = value;
    }

    public static BootLogLevel of(String label) {
        if (label == null) {
            return null;
        }
        try {
            return BootLogLevel.valueOf(label);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static BootLogLevel of(int value) {
        switch (value) {
            case 40: {
                return ERROR;
            }
            case 30: {
                return WARN;
            }
            case 20: {
                return INFO;
            }
            case 10: {
                return DEBUG;
            }
            case 0: {
                return TRACE;
            }
        }
        return null;
    }

    public boolean logTrace() {
        return this.checkLevel(TRACE);
    }

    public boolean logDebug() {
        return this.checkLevel(DEBUG);
    }

    public boolean logInfo() {
        return this.checkLevel(INFO);
    }

    public boolean logWarn() {
        return this.checkLevel(WARN);
    }

    public boolean logError() {
        return this.checkLevel(ERROR);
    }

    private boolean checkLevel(BootLogLevel check) {
        return check.value >= this.value;
    }
}

