/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.redisson.api.RFuture;
import org.redisson.misc.ProxyBuilder;
import org.redisson.reactive.CommandReactiveExecutor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveProxyBuilder {
    public static <T> T create(CommandReactiveExecutor commandExecutor, Object instance, Class<T> clazz) {
        return ReactiveProxyBuilder.create(commandExecutor, instance, null, clazz);
    }

    public static <T> T create(final CommandReactiveExecutor commandExecutor, Object instance, Object implementation, Class<T> clazz) {
        return ProxyBuilder.create(new ProxyBuilder.Callback(){

            @Override
            public Object execute(Callable<RFuture<Object>> callable, Method instanceMethod) {
                Mono result = commandExecutor.reactive(callable);
                if (instanceMethod.getReturnType().isAssignableFrom(Flux.class)) {
                    Mono monoListResult = result.cast(Iterable.class);
                    return monoListResult.flatMapMany(Flux::fromIterable);
                }
                return result;
            }
        }, instance, implementation, clazz, commandExecutor.getServiceManager());
    }
}

